% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_mistral.R
\name{mistral}
\alias{mistral}
\title{Mistral Provider Function}
\usage{
mistral(..., .called_from = NULL)
}
\arguments{
\item{...}{Parameters to be passed to the appropriate Mistral-specific function,
such as model configuration, input text, or API-specific options.}

\item{.called_from}{An internal argument that specifies which action (e.g.,
\code{chat}, \code{embed}, \code{send_batch}) the function is being invoked from.
This argument is automatically managed and should not be modified by the user.}
}
\value{
The result of the requested action, depending on the specific function invoked
(e.g., an updated \code{LLMMessage} object for \code{chat()}, or a matrix for \code{embed()}).
}
\description{
The \code{mistral()} function acts as an interface for interacting with the Mistral API
through main \code{tidyllm} verbs such as \code{chat()} and \code{embed()}.
It dynamically routes requests to Mistral-specific functions
like \code{mistral_chat()} and \code{mistral_embedding()} based on the context of the call.
}
