% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_mistral.R
\name{mistral_chat}
\alias{mistral_chat}
\title{Send LLMMessage to Mistral API}
\usage{
mistral_chat(
  .llm,
  .model = "mistral-large-latest",
  .stream = FALSE,
  .seed = NULL,
  .json = FALSE,
  .temperature = 0.7,
  .top_p = 1,
  .stop = NULL,
  .safe_prompt = FALSE,
  .timeout = 120,
  .max_tries = 3,
  .max_tokens = 1024,
  .min_tokens = NULL,
  .dry_run = FALSE,
  .verbose = FALSE
)
}
\arguments{
\item{.llm}{An \code{LLMMessage} object.}

\item{.model}{The model identifier to use (default: \code{"mistral-large-latest"}).}

\item{.stream}{Whether to stream back partial progress to the console. (default: \code{FALSE}).}

\item{.seed}{The seed to use for random sampling. If set, different calls will generate deterministic results (optional).}

\item{.json}{Whether the output should be in JSON mode(default: \code{FALSE}).}

\item{.temperature}{Sampling temperature to use, between \code{0.0} and \code{1.5}. Higher values make the output more random, while lower values make it more focused and deterministic (default: \code{0.7}).}

\item{.top_p}{Nucleus sampling parameter, between \code{0.0} and \code{1.0}. The model considers tokens with top_p probability mass (default: \code{1}).}

\item{.stop}{Stop generation if this token is detected, or if one of these tokens is detected when providing a list (optional).}

\item{.safe_prompt}{Whether to inject a safety prompt before all conversations (default: \code{FALSE}).}

\item{.timeout}{When should our connection time out in seconds (default: \code{120}).}

\item{.max_tries}{Maximum retries to peform request}

\item{.max_tokens}{The maximum number of tokens to generate in the completion. Must be \verb{>= 0} (default: \code{1024}).}

\item{.min_tokens}{The minimum number of tokens to generate in the completion. Must be \verb{>= 0} (optional).}

\item{.dry_run}{If \code{TRUE}, perform a dry run and return the request object (default: \code{FALSE}).}

\item{.verbose}{Should additional information be shown after the API call? (default: \code{FALSE})}
}
\value{
Returns an updated \code{LLMMessage} object.
}
\description{
Send LLMMessage to Mistral API
}
