% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/realtime_plot.R
\name{realtime_plot}
\alias{realtime_plot}
\title{Convenience function to plot realtime data}
\usage{
realtime_plot(station_number = NULL, Parameter = c("Flow", "Level"))
}
\arguments{
\item{station_number}{A seven digit Water Survey of Canada station number. Can only be one value.}

\item{Parameter}{Parameter of interest. Either "Flow" or "Level". Defaults to "Flow".}
}
\value{
A plot of recent realtime values
}
\description{
This is an easy way to visualize a single station using base R graphics.
More complicated plotting needs should consider using \code{ggplot2}. Inputting more
5 stations will result in very busy plots and longer load time. Legend position will
sometimes overlap plotted points.
}
\examples{
\dontrun{
## One station
realtime_plot("08MF005")

## Multiple stations
realtime_plot(c("07EC002","01AD003"))
}

}
