% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_dt.R
\name{replace_dt}
\alias{replace_dt}
\title{Fast value replacement in data frame}
\usage{
replace_dt(.data, ..., from = is.nan, to = NA)
}
\arguments{
\item{.data}{A data.frame}

\item{...}{Colunms to be replaced. If not specified, use all columns.}

\item{from}{A value, a vector of values or a function returns a logical value.
Defaults to \code{is.nan}.}

\item{to}{A value. Defaults to \code{NA}.}
}
\value{
A data.table.
}
\description{
While \code{replace_na_dt} could replace all NAs to another
value, \code{replace_dt} could replace any value(s) to another specific
value.
}
\examples{
iris \%>\% mutate_vars(is.factor,as.character) -> new_iris

new_iris \%>\%
  replace_dt(Species, from = "setosa",to = "SS")
new_iris \%>\%
  replace_dt(Species,from = c("setosa","virginica"),to = "sv")
new_iris \%>\%
  replace_dt(Petal.Width, from = .2,to = 2)
new_iris \%>\%
  replace_dt(from = .2,to = NA)
new_iris \%>\%
  replace_dt(is.numeric, from = function(x) x > 3, to = 9999 )
}
\seealso{
\code{\link[tidyfst]{replace_na_dt}}
}
