% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{incvlcomments}
\alias{incvlcomments}
\title{Incivil Comments Data}
\format{
A data frame of 3856 observations nested in 964 participants and 22 variables:
\describe{
\item{participant_num}{Numeric id of the participant}
\item{age}{Age of the participant}
\item{male}{Gender of the participant, either 'male' or 'not male'}
\item{high_education}{Level of formal education of the participant, either 'high formal education' or 'low formal education'}
\item{comment_num}{Numeric id of the comment that the participant was exposed to}
\item{issue}{The subject of the comment that the participant was exposed to, either 'Gender', 'Abortion', 'Climate', or 'Migration'}
\item{profanity}{Whether the comment contained profanities as an indicator of incivility}
\item{attacks_argument}{Whether the comment contained attacks towards arguments as an indicator of incivility}
\item{offensive_stereotyping}{Whether the comment contained offensive stereotypes as an indicator of intolerant discourse}
\item{violent_threats}{Whether the comment contained violent threats as an indicator of intolerant discourse}
\item{offensiveness}{Rate statement whether the comment is being perceived as offensive & hostile (Scale from 1 to 7)}
\item{adequacy}{Rate statement whether the comment is being perceived as necessary & accurate (Scale from 1 to 7)}
\item{harm_to_society}{Rate statement whether the comment is being perceived as harmful to society (Scale from 1 to 7)}
\item{deletion_intention}{Whether the participant wants to delete the comment}
\item{similarity_poster}{How similar the participant feels to the person who created the post (Scale from 1 to 7)}
\item{similarity_group}{How similar the participant feels to the group of people criticized in the post (Scale from 1 to 7)}
\item{attitude_gender}{Rate agreement with statements on gender policies (Scale from 1 to 7)}
\item{attitude_abortion}{Rate agreement with statements on abortion (Scale from 1 to 7)}
\item{attitude_migration}{Rate agreement with statements on migration (Scale from 1 to 7)}
\item{attitude_climate}{Rate agreement with statements on climate change (Scale from 1 to 7)}
\item{left_right_placement}{Placement on a political spectrum from left to right (Scale from 1 to 9)}
\item{freedom_of_speech}{Rate agreement with statements about the freedom of speech and expression (Scale from 1 to 7)}
}
}
\source{
\url{https://osf.io/w92vj}
}
\usage{
incvlcomments
}
\description{
A dataset of a preregistered factorial survey experiment with a nationally
representative sample of 964 German online users. Participants were presented
with manipulated user comments that included statements associated with
incivil discourse (such as profanity and attacks on arguments) and
intolerant discourse (such as offensive stereotyping and violent threats).
Participants rated the comments, e.g. offensiveness, harm to society, and
their intention to delete the comment containing the statement.
}
\details{
The dataset was created from the OSF project: \href{https://osf.io/w92vj}{Differential perceptions of and reactions to incivil and intolerant user comments},
corresponding to the paper:
Kümpel, A. S., Unkel, J (2023). Differential perceptions of and reactions to
incivil and intolerant user comments, Journal of Computer-Mediated
Communication, Volume 28, Issue 4, https://doi.org/10.1093/jcmc/zmad018
}
\keyword{datasets}
