% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/broom_methods.R
\name{broom_methods_crr}
\alias{broom_methods_crr}
\alias{tidy.tidycrr}
\alias{glance.tidycrr}
\alias{augment.tidycrr}
\title{Broom methods for tidycrr objects}
\usage{
\method{tidy}{tidycrr}(x, exponentiate = FALSE, conf.int = FALSE, conf.level = x$conf.level, ...)

\method{glance}{tidycrr}(x, ...)

\method{augment}{tidycrr}(x, times = NULL, probs = NULL, newdata = NULL, ...)
}
\arguments{
\item{x}{a tidycrr object}

\item{exponentiate}{Logical indicating whether or not to exponentiate the
coefficient estimates. Defaults to \code{FALSE}.}

\item{conf.int}{Logical indicating whether or not to include a confidence
interval in the tidied output. Defaults to \code{FALSE}.}

\item{conf.level}{Level of the confidence interval. Default matches that in
\code{crr(conf.level=)} (typically, 0.95)}

\item{...}{not used}

\item{times}{Numeric vector of times to obtain risk estimates at}

\item{probs}{Numeric vector of quantiles to obtain estimates at}

\item{newdata}{A \code{base::data.frame()} or \code{tibble::tibble()} containing all
the original predictors used to create x. Defaults to \code{NULL}.}
}
\value{
a tibble
}
\description{
Broom methods for tidycrr objects
}
\examples{
crr <- crr(Surv(ttdeath, death_cr) ~ age + grade, trial)

tidy(crr)

glance(crr)

augment(crr, times = 12)
}
\seealso{
Other crr() functions: 
\code{\link{crr}()},
\code{\link{predict.tidycrr}()}
}
\concept{crr() functions}
\concept{tidycrr tidiers}
