% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tibble_one.R
\name{tibble_one}
\alias{tibble_one}
\title{Tidy characteristics data}
\usage{
tibble_one(
  data,
  formula = NULL,
  meta_data = NULL,
  row_vars = NULL,
  strat = NULL,
  by = NULL,
  specs_table_vals = NULL,
  specs_table_tests = NULL,
  include_pval = FALSE,
  expand_binary_catgs = FALSE,
  include_freq = FALSE,
  add_perc_to_cats = TRUE
)
}
\arguments{
\item{data}{a data frame}

\item{formula}{an optional formula object. The left hand side of the
formula should be blank. The right hand side of the formula should
contain row variables for the table. The '|' symbol can be used to
include stratifying variables. If this option is used, no more than
two stratifying variables should be used, and they must be separated
by a * symbol. If formula is used, the strat, by, and row_vars inputs
are ignored.}

\item{meta_data}{a meta data frame. If unspecified, a meta data frame
will be created using \code{data}.}

\item{row_vars}{a character vector indicating column names of row
variables in the table. If unspecified, all columns are used.}

\item{strat}{a character value indicating the column name in data that
will be used to stratify the table}

\item{by}{a character value indicating the column name in data that
will be used to split the table into groups, prior to stratification.}

\item{specs_table_vals}{named vector of character values.
Names should be variables, while values should be specs.
Valid specs are 'mean' and 'median' (see examples).}

\item{specs_table_tests}{named vector of character values.
Names should be variables, while values should be specs.
Valid specs are 'params' or 'noparm' (see examples).}

\item{include_pval}{T/F, should the table include a column for p-values?
If p-values are included, factor variables are handled using
chi-square tests, continuous variables are handled using t-tests
or ANOVA, depending on the number of categories in the table
stratification.}

\item{expand_binary_catgs}{T/F, should all categories be included for
binary categorical variables? (This only applies to binary variables.)}

\item{include_freq}{T/F, should frequency values be included for
categorical variables?}

\item{add_perc_to_cats}{T/F, should categorical variable labels
be appended with a percent sign?}
}
\value{
a \link[tibble:tibble-package]{tibble} containing summary values
that describe characteristics of observations in \code{data} , which can
subsequently be sent to different modes of output
(see \link{to_word} and \link{to_kable}).
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("stable")}

Table one is a tabular description of
characteristics, e.g., demographics of patients in a clinical trial,
presented overall and also stratified by a categorical variable, e.g.
treatment group.
}
\examples{
data("pbc_tbl1")
# report median albumin instead of mean
# use kruskal wallis test for albumin
tibble_one(
  pbc_tbl1,
  formula = ~ . | trt,
  include_freq = FALSE,
  include_pval = TRUE,
  specs_table_vals = c(albumin = 'median'),
  specs_table_tests = c(albumin = 'nopars')
)

}
