% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dagitty.R
\name{select_controls}
\alias{select_controls}
\title{Select Covariate Adjustment Sets from Data}
\usage{
select_controls(
  x,
  data,
  exposure = NULL,
  outcome = NULL,
  which_set = c("first", "sample", "all"),
  ...
)
}
\arguments{
\item{x}{An input graph of class \code{dagitty}.}

\item{data}{A \code{data.frame} or object coercible by \code{as.data.frame()}.}

\item{exposure}{Atomic character, name of the exposure variable.}

\item{outcome}{Atomic character, name of the outcome variable.}

\item{which_set}{Atomic character, indicating which set of covariates to
select in case there are multiple. Valid choices are in
\code{c("first", "sample", "all")}, see Value.}

\item{...}{Other arguments passed to \link[dagitty]{adjustmentSets}}
}
\value{
If \code{which_set = "all"}, returns a list of \code{data.frames} to allow for
sensitivity analyses. Otherwise, returns a \code{data.frame}.
}
\description{
Wraps \link[dagitty]{adjustmentSets} to construct a dataset with
covariates that (asymptotically) allow unbiased estimation of causal effects
from observational data.
}
\examples{
dag <- dagitty::dagitty('dag {x -> y}')
df <- data.frame(x = rnorm(10), y = rnorm(10))
df1 <- select_controls(dag, df, exposure = "x", outcome = "y")
class(df1) == "data.frame"
df2 <- select_controls(dag, df, exposure = "x", outcome = "y", which_set = "sample")
class(df2) == "data.frame"
lst1 <- select_controls(dag, df, exposure = "x", outcome = "y", which_set = "all")
class(lst1) == "list"
}
\seealso{
\code{\link[dagitty]{adjustmentSets}}
}
