% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/um.R
\name{autocorr}
\alias{autocorr}
\alias{autocorr.um}
\title{Theoretical simple/partial autocorrelations of an ARMA model}
\usage{
autocorr(um, ...)

\method{autocorr}{um}(um, lag.max = 10, par = FALSE, ...)
}
\arguments{
\item{um}{an object of class \code{um}.}

\item{...}{additional arguments.}

\item{lag.max}{maximum lag for autocovariances.}

\item{par}{logical. If TRUE partial autocorrelations are computed.}
}
\value{
A numeric vector.
}
\description{
\code{autocorr} computes the simple/partial autocorrelations of an ARMA model.
}
\note{
The I polynomial is ignored.
}
\examples{
ar1 <- um(ar = "1-0.8B")
autocorr(ar1, lag.max = 13)
autocorr(ar1, lag.max = 13, par = TRUE)

}
