#' Retail Sales of Variety Stores (U.S. Bureau of the Census)
#'
#' 156 monthly observations from January 1967 to December 1979.
#'
#' @references 
#' Chen, C. and Liu, L. (1993) Joint Estimation of Model Parameters
#' and Outlier Effects in Time Series, Journal of the American Statistical
#' Association, Vol. 88, No. 421, pp. 284-297
#'
#' @source \url{https://www.census.gov/retail/mrts/mrtshist.html}
"rsales"

#' Series C Chemical Process Temperature Readings: Every Minute.
#'
#' 226 observations.
#'
#' @references
#' Box, G.E., Jenkins, G.M., Reinsel, G.C. and Ljung, G.M. (2015) Time Series
#' Analysis: Forecasting and Control. John Wiley & Sons, Hoboken.
#' 
#' @source \url{ftp://ftp.wiley.com/public/sci_tech_med/times_series_example}
"seriesC"

#' Gas furnace data
#' 
#' Sampling interval 9 seconds; observations for 296 pairs of data points.
#' 
#' @format A object of class data.frame with 296 rows and 2 columns: 
#' \describe{
#' \item{X}{0.60-0.04 (input gas rate in cubir feet per minute.)}
#' \item{Y}{\% CO2 in outlet gas.}
#' }
#'
#' @references
#' Box, G.E., Jenkins, G.M., Reinsel, G.C. and Ljung, G.M. (2015) Time Series
#' Analysis: Forecasting and Control. John Wiley & Sons, Hoboken.
#' 
#' @source \url{ftp://ftp.wiley.com/public/sci_tech_med/times_series_example}
"seriesJ"

#' Wisconsin Telephone Company
#'
#' Monthly data from January 1951 to October 1966.
#'
#' @format A object of class data.frame with 215 rows and 2 columns: 
#' \describe{
#'   \item{X}{Monthly outward station movements.} 
#'   \item{Y}{Montly inward station movements.} 
#' }
#'
#' @references 
#' 
#' Thompson, H. E. and Tiao, G. C. (1971) "Analysis of Telephone
#' Data: A Case Study of Forecasting Seasonal Time Series," Bell Journal of
#' Economics, The RAND Corporation, vol. 2(2), pages 515-541, Autumn.
#'
#' @source \url{http://old-www.stat.wisc.edu/sites/default/files/TR222.pdf}
"Wtelephone"

