% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brackets.R
\name{tfbrackets}
\alias{tfbrackets}
\alias{[.tf}
\alias{[<-.tf}
\title{Accessing, evaluating, subsetting and subassigning \code{tf} vectors}
\usage{
\method{[}{tf}(x, i, j, interpolate = TRUE, matrix = TRUE)

\method{[}{tf}(x, i) <- value
}
\arguments{
\item{x}{an \code{tf}}

\item{i}{index of the observations (\code{integer}ish, \code{character} or \code{logical},
usual R rules apply)}

\item{j}{The \code{arg} used to evaluate the functions. A (list of) \code{numeric}
vectors. \emph{NOT} interpreted as a column number but as the argument value of
the respective functional datum.}

\item{interpolate}{should functions be evaluated (i.e., inter-/extrapolated)
for values in \code{arg} for which no original data is available? Only relevant for
the raw data class \code{tfd}, for which it defaults to \code{TRUE}. Basis-represented
\code{tfb} are always "interpolated".}

\item{matrix}{should the result be returned as a \code{matrix} or as a list of
\code{data.frame}s? If \code{TRUE}, \code{j} has to be a (list of a) single vector of
\code{arg}. See return value.}

\item{value}{\code{tf} object for subassignment. This is typed more strictly
than concatenation:  subassignment only happens if the common type of
\code{value} and \code{x} is the same as the type of \code{x},
so subassignment never changes the type of \code{x} but may do a
potentially lossy cast of \code{value} to the type of \code{x} (with a warning).}
}
\value{
If \code{j} is missing, a subset of the functions in \code{x} as given by
\code{i}.\cr If \code{j} is given and \code{matrix == TRUE}, a numeric matrix of function
evaluations in which each row represents one function and each column
represents one \code{argval} as given in argument \code{j}, with an attribute
\code{arg}=\code{j} and row- and column-names derived from \code{x[i]} and \code{j}.\cr If
\code{j} is given and \code{matrix == FALSE}, a list of \code{tbl_df}s with columns
\code{arg} = \code{j} and \code{value} = evaluations at \code{j} for each observation in
\code{i}.
}
\description{
These functions access, subset, replace and evaluate \code{tf} objects.
For more information on creating \code{tf} objects and converting them to/from
\code{list}, \code{data.frame} or \code{matrix}, see \code{\link[=tfd]{tfd()}} and \code{\link[=tfb]{tfb()}}. See Details.\cr
}
\details{
Note that these break certain (terrible) R conventions for vector-like objects:\cr
\itemize{
\item no argument recycling,
\item no indexing with \code{NA},
\item no indexing with names not present in \code{x},
\item no indexing with integers \verb{> length(x)}
}

All of the above will trigger errors.
}
\examples{
x <- 1:3 * tfd(data = 0:10, arg = 0:10)
plot(x)
# this operator's 2nd argument is quite overloaded -- you can:
# 1. simply extract elements from the vector if no second arg is given:
x[1]
x[c(TRUE, FALSE, FALSE)]
x[-(2:3)]
# 2. use the second argument and optional additional arguments to
#    extract specific function evaluations in a number of formats:
x[1:2, c(4.5, 9)] # returns a matrix of function evaluations
x[1:2, c(4.5, 9), interpolate = FALSE] # NA for arg-values not in the original data
x[-3, seq(1, 9, by = 2), matrix = FALSE] # list of data.frames for each function
# in order to evaluate a set of observed functions on a new grid and
# save them as a functional data vector again, use `tfd` or `tfb` instead:
tfd(x, arg = seq(0, 10, by = 0.01))
}
\concept{tidyfun bracket-operator}
