% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choosekrl_bic.R
\name{choosekrl_bic}
\alias{choosekrl_bic}
\title{Perform tuning parameter (\eqn{d_1}, \eqn{d_2}, \eqn{d_3}) selection for sparse tensor clustering via BIC criterion}
\usage{
choosekrl_bic(x, k, r, l, lambda = 0, sim.times = 1, method = "L0",
  n.cores = NULL)
}
\arguments{
\item{x}{a three-dimensional array}

\item{k}{the range of \eqn{d_1}: a vector, the possible clusters numbers of mode 1}

\item{r}{the range of \eqn{d_2}: a vector, the possible clusters numbers of mode 2}

\item{l}{the range of \eqn{d_3}: a vector, the possible clusters numbers of mode 3}

\item{lambda}{a numeric value. The coefficient of the regularization term.}

\item{sim.times}{the simulation times when perform clustering of classify2() in label2().}

\item{method}{two options: "L0", "L1". Two methods use different penalties, where "L0" indicating L0 penalty, "L1" indicating Lasso penalty.}

\item{n.cores}{the number of cores}
}
\value{
a list   

\code{estimated_krl} a 1*3 matrix which is the estimated c(d_1,d_2,d_3).   

               \code{BIC} a vector which contains the BIC values of all the combination of given range.
}
\description{
Select the best \eqn{d_1}, \eqn{d_2}, \eqn{d_3}  to perform clustering. A range of values of \eqn{d_1}, \eqn{d_2}, \eqn{d_3} is usually considered - value that results in the lowest BIC is selected.
}
