% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Largest Extreme Value}
\alias{Largest Extreme Value}
\alias{qlev}
\alias{plev}
\alias{dlev}
\alias{rlev}
\title{The Largest Extreme Value Distribution}
\usage{
qlev(p, loc = 0, scale = 1)

plev(q, loc = 0, scale = 1)

dlev(x, loc = 0, scale = 1)

rlev(n, loc = 0, scale = 1)
}
\arguments{
\item{p}{Vector of probabilities}

\item{loc}{Location parameter}

\item{scale}{Scale parameter}

\item{q}{Vector of quantiles}

\item{x}{Vector of quantiles}

\item{n}{Number of observations}
}
\value{
\code{dlev} gives the density, 
        \code{plev} gives the distribution function, 
        \code{qlev} gives the quantile function, and 
        \code{rlev} generates random observations.
        
        The length of the result is determined by \code{n} 
        for \code{rlev}, and is the maximum of the lengths 
        of the numerical arguments for the other functions. 
        
        The numerical arguments other than \code{n} are 
        recycled to the length of the result.
}
\description{
Density, distribution function, quantile function and 
             random generation for the LEV distribution with location
             \code{loc} and scale \code{scale}.
}
\details{
If \code{loc} is not specified, a default 
         value of 0 is used. If \code{scale} is not 
         specified, a default value of 1 is used.
         
         The largest extreme value distribution with 
         location parameter \eqn{\mu} and
         scale \eqn{\sigma} has density
         
         \deqn{f(x;\mu,\sigma) = \frac{1}{\sigma}\phi_{_{LEV}}\left(\frac{x-\mu}{\sigma}\right),\quad -\infty < x < \infty }
         
         where \eqn{\phi_{_{LEV}}(z)} exp[-z - exp(-z)] is the density of the standard LEV distribution.
}
