ui = fluidPage(theme = add_theme(getShinyOption('theme')), 
               add_css(),
               
sidebarLayout(
  sidebarPanel(width = 3, 
    sliderInput("m.hyp", 
                label = "Number of Success States (m)",
                min = .05, 
                max = 1, 
                step=.05, 
                value = .05,
                animate = TRUE),
    sliderInput("n.hyp", 
                label = "Number of Failure States (n)",
                min = 0, 
                max = 50, 
                step = 1,
                value = 2),
    sliderInput("k.hyp", 
                label = "Number of draws (k)",
                min = .05, 
                max = 1, 
                step = .05, 
                value = .05,
                animate = TRUE)), 

mainPanel(width = 9, 
          tabsetPanel(type = "pills", 
          tabPanel("Distribution Function", 
                   metricsgraphicsOutput(height = "550px", "hypC")), 
          tabPanel("Mass",
                   metricsgraphicsOutput(height = "550px", "hypP")), 
          tabPanel("Survival", 
                   metricsgraphicsOutput(height = "550px", "hypR")), 
          tabPanel("Hazard", 
                   metricsgraphicsOutput(height = "550px", "hyph")), 
          tabPanel("Cumulative Hazard", 
                   metricsgraphicsOutput(height = "550px", "hypH")),
          tabPanel("Quantile", 
                   metricsgraphicsOutput(height = "550px", "hypQ")))))) 
