ui = fluidPage(theme = add_theme(getShinyOption('theme')), 
               add_css(),
 
sidebarLayout(
   sidebarPanel(width = 3, 
      sliderInput("shape1", 
                  label = HTML("Shape Parameter (&alpha;)"),
                  min = .5, 
                  max = 10, 
                  step = .5, 
                  value = 2,
                  animate = TRUE),
      sliderInput("shape2", 
                  label = HTML("Shape Parameter (&beta;)"),
                  min = .5, 
                  max = 10, 
                  step = .5,
                  value = .5),
      sliderInput("scale.beta", 
                  label = "Scale Parameter (d)",
                  min = 1, 
                  max = 20, 
                  step = 1, 
                  value = 1,
                  animate = TRUE),
      sliderInput("loc.beta", 
                  label = "Location Parameter (c)",
                  min = 0, 
                  max = 10, 
                  step = .5, 
                  value = 0,
                  animate = TRUE)), 

   mainPanel(width = 9, 
       tabsetPanel(type = "pills", 
          tabPanel("Distribution Function", 
                   metricsgraphicsOutput(height = "550px", "betaC")), 
          tabPanel("Mass",
                   metricsgraphicsOutput(height = "550px", "betaP")), 
          tabPanel("Survival", 
                   metricsgraphicsOutput(height = "550px", "betaR")), 
          tabPanel("Hazard", 
                   metricsgraphicsOutput(height = "550px", "betah")), 
          tabPanel("Cumulative Hazard", 
                   metricsgraphicsOutput(height = "550px", "betaH")),
          tabPanel("Quantile", 
                   metricsgraphicsOutput(height = "550px", "betaQ"))))))
