% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequency.R
\name{f.multi.weekly}
\alias{f.multi.weekly}
\title{Create a Multi-Week Frequency}
\usage{
f.multi.weekly(date, k)
}
\arguments{
\item{date}{The date, which can be a list with \code{year}, \code{month}, and \code{day} elements.
It can also be an integer array with 3 elements for year, month, and day respectively,
or an object that can be used as an argument for the \code{base::as.Date} function.}

\item{k}{The number of weeks.}
}
\value{
An object of class \code{ldtf}, which is also a list with the following members:
\item{class}{The class of this frequency.}
\item{year}{The \code{year}.}
\item{month}{The \code{month}.}
\item{day}{The \code{day}.}
\item{k}{The value of \code{k}.}
}
\description{
Use this function to create a frequency for time-series data that occurs every 'k' weeks. The first day of the first week is used as the reference.
}
\details{
To use the \code{\link{as.frequency}} function for this type of frequency,
you need the following information:
\itemize{
\item \strong{Character Format} The first day of the first week in \code{"YYYYMMDD"} format.
\item \strong{Class Id} \code{"w#"} (the number is the value of \code{k}; e.g., w3 means every 3 weeks)
}
}
\examples{

mw0 <- f.multi.weekly(c(2023, 1, 2), 3)
# This is 2/1/2023, which is Monday. The next observation belongs to 23/1/2023.

mw0_value_str <- as.character(mw0) # This will be '20230102'.
mw0_class_str <- get.class.id(mw0) # This will be 'w3'.

mw_new <- as.frequency("20230109", "w4") # This is 9/1/2023.

# Don't use invalid or unsupported dates:
\donttest{
mw_invalid <- try(as.frequency("1399109", "w4")) # this is a too old date and unsupported
mw_invalid <- try(as.frequency("20230132", "w5")) # invalid day in month
mw_invalid <- try(as.frequency("20231331", "w2")) # invalid month
mw_invalid <- try(as.frequency("20231012", "w0"))
}

}
