% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{data.wdi.agg}
\alias{data.wdi.agg}
\title{Loads and Aggregates WDI Data}
\usage{
data.wdi.agg(
  dirPath,
  minYear = 1960,
  maxYear = 2020,
  aggregateFun = NULL,
  keepFun = NULL
)
}
\arguments{
\item{dirPath}{A character string representing the path to the WDI dataset directory. It should contain the following files: ‘WDICountry-Series.csv’, ‘WDIData.csv’, ‘WDICountry.csv’, and ‘WDISeries.csv’. These files can be downloaded from the WDI website.}

\item{minYear}{An integer representing the starting year for data aggregation.}

\item{maxYear}{An integer representing the ending year for data aggregation.}

\item{aggregateFun}{A function for aggregation with the following arguments: \code{data}, \code{code}, \code{name}, \code{unit}, \code{definition}, \code{aggMethod}, where \code{data} is the data-points from \code{minYear} to \code{maxYear}, \code{unit} is the unit of measurement, \code{definition} is the long definition of the series, and \code{aggMethod} is the method of aggregation.}

\item{keepFun}{A function that determines whether to keep or omit columns of the final data matrix. It has a \code{data} argument which is the data of the column. It can check the variance or count the number of available data points and omit a variable from the analysis.}
}
\value{
A list with the following items:
\item{result}{A matrix with countries as rows and series as columns. Each data point represents the aggregated value from \code{minYear} to \code{maxYear}.}
\item{countries}{A list containing information about the countries.}
\item{series}{A list containing information about various series.}
}
\description{
Use this function to aggregate and reshape data from the World Development Indicators dataset. It creates a 'Country-Series' table.
}
\examples{
# This example requires external data. Download the data and run it:

\donttest{
try({
   path.dir <- "D:/Data/WDI" # This path must be valid
   # Define a function that calculates the long-run growth rates:
   aggregateFun <- function(data, code, name, unit, definition, aggMethod) {
     isPerc <- unit == "\%" || grepl(".ZG", code)
     if (isPerc) NA
     else get.longrun.growth(data, FALSE, TRUE, 30, 5, isPerc)
   }
   # Add some rules for removing variables from the analysis:
   keepFun <- function(data) {
        var(data, na.rm = TRUE) > 1e-12 && sum((is.na(data)) == FALSE) >= 50
   }
   data <- data.wdi.agg(path.dir, 1960, 2020, aggregateFun, keepFun)
})
}

}
