% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequency.R
\name{f.minutely}
\alias{f.minutely}
\title{Create a \code{Minute-ly} Frequency}
\usage{
f.minutely(day, minute)
}
\arguments{
\item{day}{A 'Day-based' object of class \code{ldtf}, such as \code{Daily} or \code{Daily-In-Week}.}

\item{minute}{The index of the minute in the day, which should be between 1 and 1440.}
}
\value{
An object of class \code{ldtf}. It is also a list with the following members:
\item{class}{Determines the class of this frequency.}
\item{day}{Determines the \code{day}.}
\item{minute}{Determines the \code{minute}.}
}
\description{
Use this function to create a frequency for time-series data that occurs every minute in a day or a subset of a week.
}
\details{
In order to use the \code{\link{as.frequency}} function for this type of frequency,
you need the following information:
\itemize{
\item \strong{Character Format}: \code{"YYYYMMDD:#"} (where # represents the value of \code{minute})
\item \strong{Class Id}: \code{mi|...} (where '...' represents the 'class id' of \code{day})
}
}
\examples{

mi0 <- f.minutely(f.daily(c(2023,5,16)),1200)

mi0_value_str <-  as.character(mi0) # this will be '20230516:1200'.
mi0_class_str <- get.class.id(mi0)
#     this will be 'mi|d'. The second part (i.e., 'd')
#     shows that this frequency is defined in a 'Daily' frequency.

mi_new <- as.frequency("20231101:3", "mi|i:wed-sat")

# Don't make the following mistakes:
\donttest{
mi_invalid <- try(as.frequency("20231101:3", "mi|j:wed-sat"))
#   invalid format in day-based frequency
mi_invalid <- try(f.minutely(f.daily(c(2023,5,16)),2000)) # invalid minute
}

}
