% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{get.longrun.growth}
\alias{get.longrun.growth}
\title{Calculate Long-run Growth}
\usage{
get.longrun.growth(
  data,
  continuous = FALSE,
  isPercentage = FALSE,
  trimStart = 0,
  trimEnd = 0,
  skipZero = TRUE
)
}
\arguments{
\item{data}{(numeric vector) Determines the data of the series.}

\item{continuous}{(logical) if \code{TRUE}, it will use the continuous formula.}

\item{isPercentage}{(logical) If the unit of measurement in \code{data} is percentage (e.g., growth rate), use \code{TRUE}. The long-run growth rate is calculated by the arithmetic mean for the continuous case and the geometric mean otherwise. If missing data exists, it returns \code{NA}.}

\item{trimStart}{If the number of leading \code{NA}s is larger than this number, the function returns NA. Otherwise, it finds the first non-NA value and continues the calculations.}

\item{trimEnd}{Similar to \code{trimStart}, but for the end of the series.}

\item{skipZero}{If \code{TRUE}, leading and trailing zeros are skipped, similar to \code{NA}.}
}
\value{
Long-run growth rate (percentage)
}
\description{
Use this to calculate long-run growth of a time-series data.
}
\details{
A variable can have continuous growth (\eqn{y(t)=y(0) (1+g_1)(1+g_2)\ldots (1+g_t)})
or discrete growth (\eqn{y(t)=y(0)e^{g_1}e^{g_2}\ldots e^{g_t}}) over \eqn{t} periods.
\eqn{y(0)} is the first value and \eqn{y(n)} is the last value.
By long-run growth rate, we mean a number such as \eqn{g} such that if
we start from \eqn{y(0)} and the variable growth is \eqn{g} every period,
we reach \eqn{y(t)} after t periods. This number summarizes all \eqn{g_i}s,
however, it is not generally the average of these rates.
}
\examples{
y <- c(60, 70, 80, 95)
g <- get.longrun.growth(y, isPercentage = TRUE, continuous = FALSE)
# Note that 'g' is different from 'mean(y)'.

}
