% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequency.R
\name{f.cross.section}
\alias{f.cross.section}
\title{Creates a Cross-Section Frequency}
\usage{
f.cross.section(position)
}
\arguments{
\item{position}{Position of the observation}
}
\value{
An object of class 'ldtf'. It is also a list with the following members:
\tabular{ll}{
\code{class} \tab Determines the class of this frequency.\cr
\code{position} \tab Determines the \code{position}.
}
}
\description{
This frequency is typically used for indexed data. It is represented by an integer
that indicates the position of the observation.
}
\details{
In order to use \code{\link{as.frequency}} function for this type of frequency,
you need the following information:
\itemize{
\item \strong{Character Format} \code{"#"} (the number is the \code{position})
\item \strong{Class Id} \code{"cs"}
}
}
\examples{

cs0 <- f.cross.section(10) # this initializes a cross-section frequency

cs0_value_str <-  as.character(cs0) # this will be '10'.
cs0_class_str <- get.class.id(cs0) # this will be 'cs'.

cs_new <- as.frequency("20", "cs")
#      this is a cross-section frequency. It points to position 20.

}
