% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concRespPlot.R
\name{concRespPlot}
\alias{concRespPlot}
\title{Concentration Response Plot}
\usage{
concRespPlot(row, ymin = -120, ymax = 120, draw.error.arrows = FALSE)
}
\arguments{
\item{row}{Named list containing:
\itemize{
  \item conc - conc string separated by |'s
  \item resp - response string separated by |'s
  \item method - scoring method determines plot bounds
  \item name - chemical name for plot title
  \item cutoff - noise cutoff
  \item bmr - baseline median response; level at which bmd is calculated
  \item er - fitted error term for plotting error bars
  \item a, tp, b, ga, p, la, q - other model parameters for fit curve
  \item fit_method - curve fit method
  \item bmd, bmdl, bmdu - bmd, bmd lower bound, and bmd upper bound
  \item ac50, acc - curve value at 50\% of top, curve value at cutoff
  \item top - curve top (maximal predicted change in response from baseline)
  \item name - name of the chemical
  \item assay - name of the assay, signature, or other endpoint
  \item other identifiers
}
Other elements are ignored.}

\item{ymin}{Minimum value of response for the plot}

\item{ymax}{Maximum value of response for the plot}

\item{draw.error.arrows}{If TRUE, draw lines representing the uncertainty in the response estimate,
instead of the actual response points}
}
\value{
No output.
}
\description{
Plots a concentration response curve for one sample/endpoint combination.
This is a generic function and it is expected that users will make their own versions
}
\details{
row is one row of data from concRespCore
}
\examples{

conc <- list(.03, .1, .3, 1, 3, 10, 30, 100)
resp <- list(0, .2, .1, .4, .7, .9, .6, 1.2)
row <- list(conc = conc,
            resp = resp,
            bmed = 0,
            cutoff = 0.25,
            onesd = 0.125,
            name = "some chemical",
            assay = "some assay")
res <- concRespCore(row, conthits = TRUE)
concRespPlot(res,ymin=-2.5,ymax=2.,5)


}
