% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmdobj.R
\name{bmdobj}
\alias{bmdobj}
\title{BMD Objective Function}
\usage{
bmdobj(
  bmd,
  fname,
  bmr,
  conc,
  resp,
  ps,
  mll,
  onesp,
  partype = 2,
  poly2.biphasic = TRUE,
  x_v
)
}
\arguments{
\item{bmd}{Benchmark dose.}

\item{fname}{Function name: "exp2", "exp3", "exp4", "exp5", "hillfn", "gnls",
"poly1", "poly2", or "pow".}

\item{bmr}{Benchmark response.}

\item{conc}{Vector of concentrations NOT in log units.}

\item{resp}{Vector of corresponding responses.}

\item{ps}{Named list of parameters.}

\item{mll}{Maximum log-likelihood of winning model.}

\item{onesp}{One-sided p-value.}

\item{partype}{Number for parameter type. Type 1 is y-scaling: a or tp.
Type 2 is x-scaling: b or ga, when available, a otherwise. Type 3 is
power scaling: p when available, then b or ga, then a if no others.
Since bmd is linked to the x-scale, type 2 should always be used. Other
types can also be vulnerable to underflow/overflow.}

\item{poly2.biphasic}{If poly2.biphasic = TRUE, constraints are set to allow
for the polynomial 2 model fit to be bi-phasic (i.e. non-monotonic).}

\item{x_v}{The vertex of the quadratic/parabolic fit.
Only in use when estimating the BMDL and BMDU values for the "poly2" model
when poly2.biphasic = TRUE. No default is set.}
}
\value{
Objective function value to find the zero of.
}
\description{
Utility function for bmdbounds
}
