% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_utils.R
\name{plot.biodata}
\alias{plot.biodata}
\title{Distribution plot}
\usage{
\method{plot}{biodata}(
  x,
  type = "violin",
  dots = FALSE,
  title = NULL,
  xlab = NULL,
  ylab = NULL,
  stats = NULL,
  draw = TRUE,
  axis.text.x = element_text(size = 10),
  axis.text.y = element_text(size = 8),
  cex.lab = 12,
  cex.main = 16,
  col = (scales::hue_pal())(length(unique(x$cell_type))),
  axis.title.x = element_text(size = cex.lab, face = "bold.italic", vjust = -0.5),
  axis.title.y = element_text(size = cex.lab, face = "bold.italic", vjust = -0.5),
  plot.title = element_text(size = cex.main, face = "bold", vjust = 1, hjust = 0.5),
  plot.margin = unit(c(0, 0, 0, -0.5), "cm"),
  ...
)
}
\arguments{
\item{x}{object from \code{\link[=convert2biodata]{convert2biodata()}} for a dataframe containing
columns named high (logical), cell_type (factor) and value (float).}

\item{type}{character for the type of plot to be chosen among "violin"
or "boxplot".}

\item{dots}{boolean to add all points to the graph.}

\item{title}{character for the title of the plot.}

\item{xlab}{character for the name of the X axis label.}

\item{ylab}{character for the name of the Y axis label.}

\item{stats}{object from \code{\link[=calculate_pvalue]{calculate_pvalue()}}.}

\item{draw}{bolean to plot the graph.}

\item{axis.text.x}{tick labels along axes (\code{\link[ggplot2:element]{element_text()}}). Specify all axis tick labels (\code{axis.text}),
tick labels by plane (using \code{axis.text.x} or \code{axis.text.y}), or individually
for each axis (using \code{axis.text.x.bottom}, \code{axis.text.x.top},
\code{axis.text.y.left}, \code{axis.text.y.right}). \verb{axis.text.*.*} inherits from
\verb{axis.text.*} which inherits from \code{axis.text}, which in turn inherits
from \code{text}}

\item{axis.text.y}{tick labels along axes (\code{\link[ggplot2:element]{element_text()}}). Specify all axis tick labels (\code{axis.text}),
tick labels by plane (using \code{axis.text.x} or \code{axis.text.y}), or individually
for each axis (using \code{axis.text.x.bottom}, \code{axis.text.x.top},
\code{axis.text.y.left}, \code{axis.text.y.right}). \verb{axis.text.*.*} inherits from
\verb{axis.text.*} which inherits from \code{axis.text}, which in turn inherits
from \code{text}}

\item{cex.lab}{numerical value giving the amount by which x and y plotting
labels should be magnified relative to the default.}

\item{cex.main}{numerical value giving the amount by which main plotting
title should be magnified relative to the default.}

\item{col}{character for the specification for the default plotting color.
See section 'Color Specification' in \code{\link[graphics:par]{graphics::par()}}.}

\item{axis.title.x}{labels of axes (\code{\link[ggplot2:element]{element_text()}}). Specify all axes' labels (\code{axis.title}),
labels by plane (using \code{axis.title.x} or \code{axis.title.y}), or individually
for each axis (using \code{axis.title.x.bottom}, \code{axis.title.x.top},
\code{axis.title.y.left}, \code{axis.title.y.right}). \verb{axis.title.*.*} inherits from
\verb{axis.title.*} which inherits from \code{axis.title}, which in turn inherits
from \code{text}}

\item{axis.title.y}{labels of axes (\code{\link[ggplot2:element]{element_text()}}). Specify all axes' labels (\code{axis.title}),
labels by plane (using \code{axis.title.x} or \code{axis.title.y}), or individually
for each axis (using \code{axis.title.x.bottom}, \code{axis.title.x.top},
\code{axis.title.y.left}, \code{axis.title.y.right}). \verb{axis.title.*.*} inherits from
\verb{axis.title.*} which inherits from \code{axis.title}, which in turn inherits
from \code{text}}

\item{plot.title}{plot title (text appearance) (\code{\link[ggplot2:element]{element_text()}}; inherits
from \code{title}) left-aligned by default}

\item{plot.margin}{margin around entire plot (\code{unit} with the sizes of
the top, right, bottom, and left margins)}

\item{...}{arguments to pass to \code{\link[ggplot2:theme]{ggplot2::theme()}}.}
}
\value{
No return value, called for side effects
}
\description{
Distribution plot of cell subtypes according to the expression level (high or
low) of a selected gene.
}
\examples{
library("ggplot2")
data(tcga)
(df <- convert2biodata(
    algorithm = "Cibersort_ABS",
    disease = "breast invasive carcinoma",
    tissue = "Primary Tumor",
    gene_x = "ICOS"
))
\donttest{
plot(df)
stats <- calculate_pvalue(df)
plot(
    df,
    stats = stats,
    type = "boxplot",
    dots = TRUE,
    xlab = "Expression level of the 'ICOS' gene by cell type",
    ylab = "Percent of relative abundance\n(from the Cibersort_ABS algorithm)",
    title = "Differential analysis of tumor tissue immune cell type abundance
    based on RNASeq gene-level expression from The Cancer Genome Atlas
    (TCGA) database",
    axis.text.y = element_text(size = 8, hjust = 0.5),
    plot.title =  element_text(face = "bold", hjust = 0.5)
)
}
}
