% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_delete.R
\name{tar_delete}
\alias{tar_delete}
\title{Delete target output values.}
\usage{
tar_delete(
  names,
  cloud = TRUE,
  batch_size = 1000L,
  verbose = TRUE,
  store = targets::tar_config_get("store")
)
}
\arguments{
\item{names}{Names of the targets to remove from \verb{_targets/objects/}.
You can supply symbols
or \code{tidyselect} helpers like \code{\link[=any_of]{any_of()}} and \code{\link[=starts_with]{starts_with()}}.}

\item{cloud}{Logical of length 1, whether to delete objects
from the cloud if applicable (e.g. AWS, GCP). If \code{FALSE},
files are not deleted from the cloud.}

\item{batch_size}{Positive integer between 1 and 1000,
number of target objects to delete
from the cloud with each HTTP API request.
Currently only supported for AWS.
Cannot be more than 1000.}

\item{verbose}{Logical of length 1, whether to print console messages
to show progress when deleting each batch of targets from each
cloud bucket. Batched deletion with verbosity is currently only supported
for AWS.}

\item{store}{Character of length 1, path to the
\code{targets} data store. Defaults to \code{tar_config_get("store")},
which in turn defaults to \verb{_targets/}.
When you set this argument, the value of \code{tar_config_get("store")}
is temporarily changed for the current function call.
See \code{\link[=tar_config_get]{tar_config_get()}} and \code{\link[=tar_config_set]{tar_config_set()}} for details
about how to set the data store path persistently
for a project.}
}
\description{
Delete the output values of targets in \verb{_targets/objects/}
(or the cloud if applicable)
but keep the records in the metadata.
}
\details{
If you have a small number of data-heavy targets you
need to discard to conserve storage, this function can help.
Local external files files (i.e. \code{format = "file"}
and \code{repository = "local"}) are not deleted.
For targets with \code{repository} not equal \code{"local"}, \code{tar_delete()} attempts
to delete the file and errors out if the deletion is unsuccessful.
If deletion fails, either log into the cloud platform
and manually delete the file (e.g. the AWS web console
in the case of \code{repository = "aws"}) or call
\code{\link[=tar_invalidate]{tar_invalidate()}} on that target so that \code{targets}
does not try to delete the object.
For patterns recorded in the metadata, all the branches
will be deleted. For patterns no longer in the metadata,
branches are left alone.
}
\section{Storage access}{

Several functions like \code{tar_make()}, \code{tar_read()}, \code{tar_load()},
\code{tar_meta()}, and \code{tar_progress()} read or modify
the local data store of the pipeline.
The local data store is in flux while a pipeline is running,
and depending on how distributed computing or cloud computing is set up,
not all targets can even reach it. So please do not call these
functions from inside a target as part of a running
pipeline. The only exception is literate programming
target factories in the \code{tarchetypes} package such as \code{tar_render()}
and \code{tar_quarto()}.


Several functions like \code{tar_make()}, \code{tar_read()}, \code{tar_load()},
\code{tar_meta()}, and \code{tar_progress()} read or modify
the local data store of the pipeline.
The local data store is in flux while a pipeline is running,
and depending on how distributed computing or cloud computing is set up,
not all targets can even reach it. So please do not call these
functions from inside a target as part of a running
pipeline. The only exception is literate programming
target factories in the \code{tarchetypes} package such as \code{tar_render()}
and \code{tar_quarto()}.
}

\section{Cloud target data versioning}{

Some buckets in Amazon S3 or Google Cloud Storage are "versioned",
which means they track historical versions of each data object.
If you use \code{targets} with cloud storage
(\url{https://books.ropensci.org/targets/cloud-storage.html})
and versioning is turned on, then \code{targets} will record each
version of each target in its metadata.

Functions like \code{\link[=tar_read]{tar_read()}}
and \code{\link[=tar_load]{tar_load()}} load the version recorded in the local metadata,
which may not be the same as the "current" version of the
object in the bucket. Likewise, functions \code{\link[=tar_delete]{tar_delete()}}
and \code{\link[=tar_destroy]{tar_destroy()}} only remove
the version ID of each target as recorded in the local
metadata.

If you want to interact with the \emph{latest} version of an object
instead of the version ID recorded in the local metadata,
then you will need to delete the object from the metadata.
\enumerate{
\item Make sure your local copy of the metadata is current and
up to date. You may need to run \code{\link[=tar_meta_download]{tar_meta_download()}} or
\code{\link[=tar_meta_sync]{tar_meta_sync()}} first.
\item Run \code{\link[=tar_unversion]{tar_unversion()}} to remove the recorded version IDs of
your targets in the local metadata.
\item With the version IDs gone from the local metadata,
functions like \code{\link[=tar_read]{tar_read()}} and \code{\link[=tar_destroy]{tar_destroy()}} will use the
\emph{latest} version of each target data object.
\item Optional: to back up the local metadata file with the version IDs
deleted, use \code{\link[=tar_meta_upload]{tar_meta_upload()}}.
}
}

\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
tar_script({
  list(
    tar_target(y1, 1 + 1),
    tar_target(y2, 1 + 1),
    tar_target(z, y1 + y2)
  )
}, ask = FALSE)
tar_make()
tar_delete(starts_with("y")) # Only deletes y1 and y2.
tar_make() # y1 and y2 rerun but return the same values, so z is up to date.
})
}
}
\seealso{
Other clean: 
\code{\link{tar_destroy}()},
\code{\link{tar_invalidate}()},
\code{\link{tar_prune_list}()},
\code{\link{tar_prune}()},
\code{\link{tar_unversion}()}
}
\concept{clean}
