% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_load_globals.R
\name{tar_load_globals}
\alias{tar_load_globals}
\title{Load globals for debugging, testing, and prototyping}
\usage{
tar_load_globals(
  envir = parent.frame(),
  script = targets::tar_config_get("script")
)
}
\arguments{
\item{envir}{Environment to source the target script (default: \verb{_targets.R}).
Defaults to the calling environment.}

\item{script}{Character of length 1, path to the target script file
that defines the pipeline (\verb{_targets.R} by default).
This path should be either
an absolute path or a path relative to the project root where you will
call \code{\link[=tar_make]{tar_make()}} and other functions. When \code{\link[=tar_make]{tar_make()}} and friends
run the script from the current working directory.
If the argument \code{NULL}, the setting is not modified.
Use \code{\link[=tar_config_unset]{tar_config_unset()}} to delete a setting.}
}
\value{
\code{NULL} (invisibly).
}
\description{
Load user-defined packages, functions, global objects, and
settings defined in the target script file (default: \verb{_targets.R}).
This function is for debugging, testing, and prototyping only.
It is not recommended for use inside a serious pipeline
or to report the results of a serious pipeline.
}
\details{
This function first sources the target script file
(default: \verb{_targets.R})
to loads all user-defined functions, global objects, and settings
into the current R process. Then, it loads all the packages defined
in \code{tar_option_get("packages")} (default: \code{(.packages())})
using \code{library()} with \code{lib.loc} defined in \code{tar_option_get("library")}
(default: \code{NULL}).
}
\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
tar_script({
  tar_option_set(packages = "callr")
  analyze_data <- function(data) {
    summary(data)
  }
  list(
    tar_target(x, 1 + 1),
    tar_target(y, 1 + 1)
  )
}, ask = FALSE)
tar_load_globals()
print(analyze_data)
print("callr" \%in\% (.packages()))
})
}
}
\seealso{
Other debug: 
\code{\link{tar_traceback}()},
\code{\link{tar_workspaces}()},
\code{\link{tar_workspace}()}
}
\concept{debug}
