% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_workspace_download.R
\name{tar_workspace_download}
\alias{tar_workspace_download}
\title{Download a workspace from the cloud.}
\usage{
tar_workspace_download(
  name,
  script = targets::tar_config_get("script"),
  store = targets::tar_config_get("store"),
  verbose = TRUE
)
}
\arguments{
\item{name}{Symbol, name of the target whose workspace to download.}

\item{script}{Character string, file path to the \verb{_targets.R} file
defining the pipeline. Must be configured with the right \code{aws}
and \code{repository_meta} options (in \code{\link[=tar_option_set]{tar_option_set()}})
to support downloading workspaces from the cloud.}

\item{store}{Character of length 1, path to the
\code{targets} data store. Defaults to \code{tar_config_get("store")},
which in turn defaults to \verb{_targets/}.
When you set this argument, the value of \code{tar_config_get("store")}
is temporarily changed for the current function call.
See \code{\link[=tar_config_get]{tar_config_get()}} and \code{\link[=tar_config_set]{tar_config_set()}} for details
about how to set the data store path persistently
for a project.}

\item{verbose}{\code{TRUE} to print an informative message describing the
download, \code{FALSE} to stay silent.}
}
\value{
\code{NULL} (invisibly). Returns an error if the workspace
cannot be downloaded.
}
\description{
Download a workspace file from the cloud
so it can be loaded with \code{\link[=tar_workspace]{tar_workspace()}}.
}
\details{
If \code{tar_option_get("repository_meta")} is \code{"aws"} or \code{"gcp"}, then
\code{\link[=tar_make]{tar_make()}} uploads workspaces to the bucket and prefix provided.
Download one of these workspaces with \code{\link[=tar_workspace_download]{tar_workspace_download()}}.
Downloaded workspaces can be loaded the usual way with
\code{\link[=tar_workspace]{tar_workspace()}}, and you should see them in
character vector returned by \code{\link[=tar_workspaces]{tar_workspaces()}}.
}
\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
tmp <- sample(1)
tar_script({
  library(targets)
  library(tarchetypes)
  tar_option_set(
    resources = tar_resources(
      tar_resources_aws(
        bucket = "YOUR_AWS_BUCKET",
        prefix = "_targets"
      )
    ),
    repository = "aws",
    repository_meta = "aws"
  )
  list(
    tar_target(x, stop("this is an error and thus triggers a workspace"))
  )
}, ask = FALSE)
# The following code throws an error for demonstration purposes.
try(tar_make())
# Say the workspace file for target x does not exist.
unlink("_targets/workspaces/x")
file.exists("_targets/workspaces/x")
# We can download it with tar_workspace_download()
tar_workspace_download(x)
file.exists("_targets/workspaces/x")
tar_workspace(x)
})
}
}
\seealso{
Other debug: 
\code{\link{tar_load_globals}()},
\code{\link{tar_traceback}()},
\code{\link{tar_workspace}()},
\code{\link{tar_workspaces}()}
}
\concept{debug}
