% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_source.R
\name{tar_source}
\alias{tar_source}
\title{Run R scripts.}
\usage{
tar_source(
  files = "R",
  envir = targets::tar_option_get("envir"),
  change_directory = FALSE
)
}
\arguments{
\item{files}{Character vector of file and directory paths
to look for R scripts to run. Paths must either be absolute
paths or must be relative to the current working directory
just before the function call.}

\item{envir}{Environment to run the scripts. Defaults to
\code{tar_option_get("envir")}, the environment of the pipeline.}

\item{change_directory}{Logical, whether to temporarily change
the working directory to the directory of each R script
before running it.}
}
\value{
\code{NULL} (invisibly)
}
\description{
Run all the R scripts in a directory
in the environment specified.
}
\details{
\code{tar_source()} is a convenient way to load R scripts
in \verb{_targets.R} to make custom functions available to the pipeline.
\code{tar_source()} recursively looks for files ending
in \code{.R} or \code{.r}, and it runs each with
\code{eval(parse(text = readLines(script_file, warn = FALSE)), envir)}.
}
\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
# Running in tar_dir(), these files are written in tempdir().
dir.create("R")
writeLines("f <- function(x) x + 1", file.path("R", "functions.R"))
tar_script({
  tar_source()
  list(tar_target(x, f(1)))
})
tar_make()
tar_read(x) # 2
})
}
}
\seealso{
Other utilities: 
\code{\link{tar_active}()},
\code{\link{tar_call}()},
\code{\link{tar_cancel}()},
\code{\link{tar_definition}()},
\code{\link{tar_envir}()},
\code{\link{tar_group}()},
\code{\link{tar_name}()},
\code{\link{tar_path_script_support}()},
\code{\link{tar_path_script}()},
\code{\link{tar_path_store}()},
\code{\link{tar_path_target}()},
\code{\link{tar_path}()},
\code{\link{tar_seed}()},
\code{\link{tar_store}()}
}
\concept{utilities}
