% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_watch.R
\name{tar_watch}
\alias{tar_watch}
\title{Shiny app to watch the dependency graph.}
\usage{
tar_watch(
  seconds = 10,
  seconds_min = 1,
  seconds_max = 60,
  seconds_step = 1,
  targets_only = FALSE,
  exclude = ".Random.seed",
  outdated = FALSE,
  label = NULL,
  level_separation = 150,
  degree_from = 1L,
  degree_to = 1L,
  config = "_targets.yaml",
  height = "650px",
  display = "summary",
  displays = c("summary", "branches", "progress", "graph", "about"),
  background = TRUE,
  browse = TRUE,
  host = getOption("shiny.host", "127.0.0.1"),
  port = getOption("shiny.port", targets::tar_random_port()),
  verbose = TRUE,
  supervise = TRUE,
  poll_connection = TRUE,
  stdout = "|",
  stderr = "|"
)
}
\arguments{
\item{seconds}{Numeric of length 1,
default number of seconds between refreshes of the graph.
Can be changed in the app controls.}

\item{seconds_min}{Numeric of length 1, lower bound of \code{seconds}
in the app controls.}

\item{seconds_max}{Numeric of length 1, upper bound of \code{seconds}
in the app controls.}

\item{seconds_step}{Numeric of length 1, step size of \code{seconds}
in the app controls.}

\item{targets_only}{Logical, whether to restrict the output to just targets
(\code{FALSE}) or to also include global functions and objects.}

\item{exclude}{Character vector of nodes to omit from the graph.}

\item{outdated}{Logical, whether to show colors to distinguish outdated
targets from up-to-date targets. (Global functions and objects
still show these colors.) Looking for outdated targets
takes a lot of time for large pipelines with lots of branches,
and setting \code{outdated} to \code{FALSE} is a nice way to speed up the graph
if you only want to see dependency relationships and build progress.}

\item{label}{Label argument to \code{\link[=tar_visnetwork]{tar_visnetwork()}}.}

\item{level_separation}{Numeric of length 1,
\code{levelSeparation} argument of \code{visNetwork::visHierarchicalLayout()}.
Controls the distance between hierarchical levels.
Consider changing the value if the aspect ratio of the graph
is far from 1. If \code{level_separation} is \code{NULL},
the \code{levelSeparation} argument of \code{visHierarchicalLayout()}
defaults to \code{150}.}

\item{degree_from}{Integer of length 1. When you click on a node,
the graph highlights a neighborhood of that node. \code{degree_from}
controls the number of edges the neighborhood extends upstream.}

\item{degree_to}{Integer of length 1. When you click on a node,
the graph highlights a neighborhood of that node. \code{degree_to}
controls the number of edges the neighborhood extends downstream.}

\item{config}{Character of length 1, path to the YAML file with
all the configuration settings (default: \verb{_targets.yaml}).}

\item{height}{Character of length 1,
height of the \code{visNetwork} widget and branches table.}

\item{display}{Character of length 1, which display to show first.}

\item{displays}{Character vector of choices for the display.
Elements can be any of
\code{"graph"}, \code{"summary"}, \code{"branches"}, or \code{"about"}.}

\item{background}{Logical, whether to run the app in a background process
so you can still use the R console while the app is running.}

\item{browse}{Whether to open the app in a browser when the app is ready.
Only relevant if \code{background} is \code{TRUE}.}

\item{host}{Character of length 1, IPv4 address to listen on.
Only relevant if \code{background} is \code{TRUE}.}

\item{port}{Positive integer of length 1, TCP port to listen on.
Only relevant if \code{background} is \code{TRUE}.}

\item{verbose}{whether to print a spinner and informative messages.
Only relevant if \code{background} is \code{TRUE}.}

\item{supervise}{Whether to register the process with a supervisor. If \code{TRUE},
the supervisor will ensure that the process is killed when the R process
exits.}

\item{poll_connection}{Whether to have a control connection to
the process. This is used to transmit messages from the subprocess
to the main process.}

\item{stdout}{The name of the file the standard output of
the child R process will be written to.
If the child process runs with the \code{--slave} option (the default),
then the commands are not echoed and will not be shown
in the standard output. Also note that you need to call \code{print()}
explicitly to show the output of the command(s).}

\item{stderr}{The name of the file the standard error of
the child R process will be written to.
In particular \code{message()} sends output to the standard
error. If nothing was sent to the standard error, then this file
will be empty. This argument can be the same file as \code{stdout},
in which case they will be correctly interleaved. If this is the
string \code{"2>&1"}, then standard error is redirected to standard output.}
}
\value{
A handle to \code{callr::r_bg()} background process running the app.
}
\description{
Launches a background process with a Shiny app
that calls \code{\link[=tar_visnetwork]{tar_visnetwork()}} every few seconds.
To embed this app in other apps, use the Shiny module
in \code{\link[=tar_watch_ui]{tar_watch_ui()}} and \code{\link[=tar_watch_server]{tar_watch_server()}}.
}
\details{
The controls of the app are in the left panel.
The \code{seconds} control is the number of seconds between
refreshes of the graph, and the other settings match
the arguments of \code{\link[=tar_visnetwork]{tar_visnetwork()}}.
}
\examples{
if (identical(Sys.getenv("TAR_INTERACTIVE_EXAMPLES"), "true")) {
tar_dir({ # tar_dir() runs code from a temporary directory.
tar_script({
  sleep_run <- function(...) {
    Sys.sleep(10)
  }
  list(
    tar_target(settings, sleep_run()),
    tar_target(data1, sleep_run(settings)),
    tar_target(data2, sleep_run(settings))
  )
}, ask = FALSE)
# Launch the app in a background process.
tar_watch(seconds = 10, outdated = FALSE, targets_only = TRUE)
# Run the pipeline.
tar_make()
})
}
}
\seealso{
Other progress: 
\code{\link{tar_built}()},
\code{\link{tar_canceled}()},
\code{\link{tar_errored}()},
\code{\link{tar_poll}()},
\code{\link{tar_progress_branches}()},
\code{\link{tar_progress_summary}()},
\code{\link{tar_progress}()},
\code{\link{tar_skipped}()},
\code{\link{tar_started}()},
\code{\link{tar_watch_server}()},
\code{\link{tar_watch_ui}()}
}
\concept{progress}
