% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_process.R
\name{tar_process}
\alias{tar_process}
\title{Get main process info.}
\usage{
tar_process(names = NULL, store = targets::tar_config_get("store"))
}
\arguments{
\item{names}{Optional, names of the data points to return.
If supplied, \code{tar_process()}
returns only the rows of the names you select.
You can supply symbols
or \code{tidyselect} helpers like \code{\link[=all_of]{all_of()}} and \code{\link[=starts_with]{starts_with()}}.
If \code{NULL}, all names are selected.}

\item{store}{Character of length 1, path to the
\code{targets} data store. Defaults to \code{tar_config_get("store")},
which in turn defaults to \verb{_targets/}.
When you set this argument, the value of \code{tar_config_get("store")}
is temporarily changed for the current function call.
See \code{\link[=tar_config_get]{tar_config_get()}} and \code{\link[=tar_config_set]{tar_config_set()}} for details
about how to set the data store path persistently
for a project.}
}
\value{
A data frame with metadata on the most recent main R process
to orchestrate the targets of the current project.
The output includes the \code{pid} of the main process.
}
\description{
Get info on the most recent main R process
to orchestrate the targets of the current project.
}
\details{
The main process is the R process invoked
by \code{\link[=tar_make]{tar_make()}} or similar. If \code{callr_function} is not \code{NULL},
this is an external process, and the \code{pid} in the return value
will not agree with \code{Sys.getpid()} in your current interactive session.
The process may or may not be alive. You may want to
check the status with \code{tar_pid() \%in\% ps::ps_pids()}
before running another call to \code{\link[=tar_make]{tar_make()}}
for the same project.
}
\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) {
tar_dir({ # tar_dir() runs code from a temporary directory.
tar_script({
  list(
    tar_target(x, seq_len(2)),
    tar_target(y, 2 * x, pattern = map(x))
  )
}, ask = FALSE)
tar_make()
tar_process()
tar_process(pid)
})
}
}
\seealso{
Other data: 
\code{\link{tar_load_raw}()},
\code{\link{tar_load}()},
\code{\link{tar_meta}()},
\code{\link{tar_objects}()},
\code{\link{tar_pid}()},
\code{\link{tar_read_raw}()},
\code{\link{tar_read}()}
}
\concept{data}
