% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/units.R
\name{change_units}
\alias{change_units}
\title{Convert radioactivity units}
\usage{
change_units(x, to_unit, from_unit)
}
\arguments{
\item{x}{time-activity curve or numeric object}

\item{to_unit}{the desired unit (e.g. "kBq")}

\item{from_unit}{not used for tac object (it is in the tac object), but for 
numeric objects, must be specified (e.g. "nCi")}
}
\value{
the converted object, same type as x
}
\description{
Change the radioactivity units of a tac or numeric object to the specified
desired units (e.g. Bq, kBq, MBq, nCi, uCi, mCi, Ci). For convenience, if the
unit is per volume ("x/cc" or "x/mL"), the "/cc" part is ignored for the 
conversion.
}
\examples{
f <- system.file("extdata", "AD06.tac", package="tacmagic")
AD06_tac <- load_tac(f, format="PMOD")
AD06_tac_nCicc <- change_units(AD06_tac, to_unit = "nCi/cc")

change_units(5, to_unit = "kBq", from_unit = "nCi")
change_units(0.185, to_unit = "nCi", from_unit = "kBq")
}
\concept{unit functions}
