% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot_ford.R
\docType{methods}
\name{plot_ford}
\alias{plot_ford}
\alias{plot_ford-method}
\alias{Ford}
\alias{plot_ford,matrix-method}
\alias{plot_ford,data.frame-method}
\title{Ford Diagram}
\usage{
plot_ford(object, ...)

\S4method{plot_ford}{matrix}(
  object,
  weights = FALSE,
  EPPM = FALSE,
  fill = "darkgrey",
  border = NA,
  axes = TRUE,
  ...
)

\S4method{plot_ford}{data.frame}(
  object,
  weights = FALSE,
  EPPM = FALSE,
  fill = "darkgrey",
  border = NA,
  axes = TRUE,
  ...
)
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} \code{numeric} \code{\link{matrix}} or
\code{\link{data.frame}} of count data (absolute frequencies giving the number of
individuals for each category, i.e. a contingency table).}

\item{...}{Currently not used.}

\item{weights}{A \code{\link{logical}} scalar: should the row sums be displayed?}

\item{EPPM}{A \code{\link{logical}} scalar: should the EPPM be drawn?
See \code{seriograph()}.}

\item{fill}{The color for filling the bars.}

\item{border}{The color to draw the borders.}

\item{axes}{A \code{\link{logical}} scalar: should axes be drawn on the plot? It will
omit labels where they would abut or overlap previously drawn labels.}
}
\value{
\code{plot_ford()} is called for its side-effects: it results in a graphic
being displayed (invisibly returns \code{object}).
}
\description{
Plots a Ford (battleship curve) diagram.
}
\examples{
## Data from Lipo et al. 2015
data("mississippi", package = "folio")

## Plot a Ford diagram
plot_ford(mississippi)

plot_ford(mississippi, weights = TRUE)
}
\references{
Ford, J. A. (1962). \emph{A quantitative method for deriving cultural
chronology}. Washington, DC: Pan American Union. Technical manual 1.
}
\seealso{
Other plot methods: 
\code{\link{matrigraph}()},
\code{\link{plot_bertin}()},
\code{\link{plot_diceleraas}()},
\code{\link{plot_diversity}},
\code{\link{plot_heatmap}()},
\code{\link{plot_rank}()},
\code{\link{plot_rarefaction}},
\code{\link{plot_spot}()},
\code{\link{seriograph}()}
}
\author{
N. Frerebeau
}
\concept{plot methods}
