% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/diversity_alpha.R
\docType{methods}
\name{index_chao2}
\alias{index_chao2}
\alias{index_chao2-method}
\alias{index_chao2,matrix-method}
\title{Chao2 Estimator}
\usage{
index_chao2(x, ...)

\S4method{index_chao2}{matrix}(x, unbiased = FALSE, improved = FALSE, ...)
}
\arguments{
\item{x}{A \eqn{m \times p}{m x p} \code{\link{matrix}} of presence/absence data
(incidence).}

\item{...}{Currently not used.}

\item{unbiased}{A \code{\link{logical}} scalar: should the bias-corrected estimator be
used?}

\item{improved}{A \code{\link{logical}} scalar: should the improved estimator be used?}
}
\value{
A \code{\link{numeric}} vector.
}
\description{
Chao2 Estimator
}
\references{
Chao, A. (1987). Estimating the Population Size for Capture-Recapture Data
with Unequal Catchability. \emph{Biometrics} 43(4), 783-791.

Chiu, C.-H., Wang, Y.-T., Walther, B. A. & Chao, A. (2014). An improved
nonparametric lower bound of species richness via a modified good-turing
frequency formula. \emph{Biometrics}, 70(3), 671-682.
\doi{10.2307/2531532}.
}
\seealso{
Other alpha diversity measures: 
\code{\link{index_ace}()},
\code{\link{index_baxter}()},
\code{\link{index_berger}()},
\code{\link{index_boone}()},
\code{\link{index_brillouin}()},
\code{\link{index_chao1}()},
\code{\link{index_hurlbert}()},
\code{\link{index_ice}()},
\code{\link{index_margalef}()},
\code{\link{index_mcintosh}()},
\code{\link{index_menhinick}()},
\code{\link{index_shannon}()},
\code{\link{index_simpson}()},
\code{\link{index_squares}()}
}
\author{
N. Frerebeau
}
\concept{alpha diversity measures}
