% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot_bertin.R
\docType{methods}
\name{plot_bertin}
\alias{plot_bertin}
\alias{plot_bertin-method}
\alias{Bertin}
\alias{plot_bertin,matrix-method}
\alias{plot_bertin,data.frame-method}
\title{Bertin Diagram}
\usage{
plot_bertin(object, ...)

\S4method{plot_bertin}{matrix}(object, threshold = NULL, scale = NULL)

\S4method{plot_bertin}{data.frame}(object, threshold = NULL, scale = NULL)
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} \code{numeric} \code{\link{matrix}} or
\code{\link{data.frame}} of count data (absolute frequencies giving the number of
individuals for each class).}

\item{...}{Currently not used.}

\item{threshold}{A \code{\link{function}} that takes a numeric vector as argument and
returns a numeric threshold value (see below). If \code{NULL} (the default), no
threshold is computed.}

\item{scale}{A \code{\link{function}} used to scale each variable, that takes a numeric
vector as argument and returns a numeric vector. If \code{NULL} (the default), no
scaling is performed.}
}
\value{
A \link[ggplot2:ggplot]{ggplot2::ggplot} object.
}
\description{
Plots a Bertin diagram.
}
\section{Bertin Matrix}{

As de Falguerolles \emph{et al.} (1997) points out:
"In abstract terms, a Bertin matrix is a matrix
of  displays. \link{...} To fix ideas, think of a data matrix, variable by case,
with real valued variables. For each variable, draw a bar chart of variable
value by case. High-light all bars representing a value above some sample
threshold for that variable."
}

\examples{
## Ceramic data
data("mississippi", package = "folio")

## Plot a Bertin diagram...
## ...without threshold
plot_bertin(mississippi)

## ...with variables scaled to 0-1 and the variable mean as threshold
scale_01 <- function(x) (x - min(x)) / (max(x) - min(x))
plot_bertin(mississippi, threshold = mean, scale = scale_01)
}
\references{
Bertin, J. (1977). \emph{La graphique et le traitement graphique de
l'information}. Paris: Flammarion. Nouvelle Bibliothèque Scientifique.

de Falguerolles, A., Friedrich, F. & Sawitzki, G. (1997). A Tribute to J.
Bertin's Graphical Data Analysis. In W. Badilla & F. Faulbaum (eds.),
\emph{SoftStat '97: Advances in Statistical Software 6}. Stuttgart: Lucius
& Lucius, p. 11-20.
}
\seealso{
Other plot methods: 
\code{\link{matrigraph}()},
\code{\link{plot_diceleraas}()},
\code{\link{plot_diversity}},
\code{\link{plot_ford}()},
\code{\link{plot_heatmap}()},
\code{\link{plot_rank}()},
\code{\link{plot_spot}()},
\code{\link{seriograph}()}
}
\author{
N. Frerebeau
}
\concept{plot methods}
