% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{RefineCA-class}
\alias{RefineCA-class}
\alias{.RefineCA}
\title{Partial Bootstrap CA}
\description{
An S4 class to store partial bootstrap correspondence analysis results.
}
\section{Slots}{

\describe{
\item{\code{row_chull}}{A three columns \code{\link{numeric}} matrix giving the vertices
coordinates (\code{x}, \code{y}) of the samples convex hull and a identifier (\code{id}) to
link each row to a sample.}

\item{\code{row_lengths}}{A named \code{\link{numeric}} vector giving the convex hull maximum
dimension length of samples.}

\item{\code{row_keep}}{An \code{\link{integer}} vector giving the subscript of the samples to
be kept.}

\item{\code{column_chull}}{A three columns \code{\link{numeric}} matrix giving the vertices
coordinates (\code{x}, \code{y}) of the variables convex hull and a identifier (\code{id})
to link each row to a variable.}

\item{\code{column_lengths}}{A \code{\link{numeric}} vector giving the convex hull maximum
dimension length of variables.}

\item{\code{column_keep}}{An \code{\link{integer}} vector giving the subscript of the variables
to be kept.}

\item{\code{cutoff}}{A length-two \code{\link{numeric}} vector giving the cutoff value for
samples and variables selection, respectively.}
}}

\section{Subset}{

In the code snippets below, \code{x} is a \code{RefineCA} object.
\describe{
\item{\code{x[[i]]}}{Extracts information from a slot selected by subscript \code{i}.
\code{i} is a length-one \code{\link{character}} vector. Returns the corresponding slot
values.}
}
}

\seealso{
\code{\link[dimensio:CA-class]{dimensio::CA}}

Other class: 
\code{\link{DiversityIndex}},
\code{\link{PermutationOrder-class}}
}
\author{
N. Frerebeau
}
\concept{class}
