% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot.R
\docType{methods}
\name{plotDate}
\alias{plotDate}
\alias{plotDate-method}
\alias{plotDate,DateModel-method}
\title{Date plot}
\usage{
plotDate(object, ...)

\S4method{plotDate}{DateModel}(object, type = c("event", "accumulation"),
  select = 1, n = 500)
}
\arguments{
\item{object}{An object of class \linkS4class{DateModel} to be plotted.}

\item{...}{Further arguments passed to other methods.}

\item{type}{A \code{\link{character}} string or vector of character strings
indicating the modelled dates to be plotted. It must be one or both
(default) of \code{event} and \code{accumulation}. Any unambiguous substring
can be given.}

\item{select}{A \code{\link{numeric}} or \code{\link{character}} vector
giving the selection of the assemblage that are drawn.}

\item{n}{A length-one non-negative \code{\link{numeric}} vector giving the
desired length of the vector of quantiles for density computation.}
}
\description{
Plots date estimates.
}
\details{
Plots the two probability estimate density curves of
 archaeological assembalge dates (\emph{event} and
 \emph{accumulation} dates; Bellanger and Husi 2012).

 The estimated probability density of an event date is approached by a normal
 distribution. The distribution of the accumulation time of each context is
 approached by a Gaussian mixture.

 The \emph{event date} is plotted as a line, while the \emph{accumulation
 time} is shown as a grey filled area.
}
\references{
Bellanger, L. & Husi, P. (2012). Statistical Tool for Dating and
 Interpreting Archaeological Contexts Using Pottery. \emph{Journal of
 Archaeological Science}, 39(4), 777-790.
 DOI: \href{https://doi.org/10.1016/j.jas.2011.06.031}{10.1016/j.jas.2011.06.031}.
}
\seealso{
\link{dateEvent}

Other plot: \code{\link{plotBar}},
  \code{\link{plotMatrix}}, \code{\link{plotRank}},
  \code{\link{plotSpot}}
}
\author{
N. Frerebeau
}
\concept{plot}
