% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/date.R
\docType{methods}
\name{dateEvent}
\alias{dateEvent}
\alias{dateEvent-method}
\alias{dateEvent,CountMatrix-method}
\title{Date archaeological assemblages}
\usage{
dateEvent(object, ...)

\S4method{dateEvent}{CountMatrix}(object, dates, level = 0.95,
  cutoff = 90, jackknife = FALSE, bootstrap = FALSE, n = 1000, ...)
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} matrix of count data.}

\item{...}{Further arguments to be passed to \code{\link[FactoMineR]{CA}}.}

\item{dates}{A list of \code{\link{numeric}} dates.
Dates will be matched with assemblage by names.}

\item{level}{A length-one \code{\link{numeric}} vector giving the
confidence level.}

\item{cutoff}{An \code{\link{integer}} giving the cumulative percentage of
variance used to select CA factorial components for linear model fitting
(see details). All compounds with a cumulative percentage of variance of
less than the \code{cutoff} value will be retained.}

\item{jackknife}{A \code{\link{logical}} scalar: should the model be checked
by jackknife estimation (removing each fabric/type one at a time)?}

\item{bootstrap}{A \code{\link{logical}} scalar: should the model be checked
by bootstrap resampling?}

\item{n}{A non-negative \code{\link{integer}} giving the number of partial
bootstrap replications (see details).}
}
\value{
An object of class \linkS4class{DateModel}.
}
\description{
Experimental (see note).
}
\details{
This is an implementation of the chronological modeling method developed by
 Bellanger and Husi (2012, 2013).

 This method allows the estimation of two probability densities. The
 first one (\emph{event date}) represents the \emph{terminus post-quem} of an
 archaeological assemblage: an event dated in calendar time. The second
 represents the "chronological profile" of the assemblage: the accumulation
 rate (Bellanger and Husi 2012).

 This method - somewhat similar to that described by Poblome and Groenen
 2003 - is based on the adjustment of a Gaussian multiple linear regression
 model on the factors resulting from a correspondence analysis. This model
 results from the known dates of a selection of reliable contexts and allows
 to predict the \emph{event} dates of the remaining assemblage with a 95%
 confidence interval.

 Since correspondence analysis allows the rows and columns of a contingency
 table to be projected in the same space (through the transition formula),
 it is possible to estimate the date of each fabric using the previous model.
 Finally, the \emph{accumulation} date of each context is defined as the
 mean of the fabric dates, weighted by their relative proportions in that
 context (akin to the \emph{Mean Ceramic Date} proposed by South 1977).

 This method relies on strong archaeological and statistical assumptions.
 Use it if you know what you are doing (see references below).
}
\note{
The original authors of the method did not publish the data supporting their
 demonstration and some elements are unclear. As such, no replication of
 their results is possible and this implementation should be considered
 \strong{EXPERIMENTAL}. It may be subject to major changes in a future
 release.
}
\section{Model checking}{

 Resampling methods can be used to check the stability of the resulting
 model. If \code{jackknife} is \code{TRUE}, one type/fabric is removed at a
 time and all statistics are recalculated. In this way, one can assess
 whether certain type/fabric has a substantial influence on the date
 estimate. If \code{bootstrap} is \code{TRUE}, a large number of new
 bootstrap assemblages is created, with the same sample size, by resampling
 each of the original assemblage with replacement. Then, examination of the
 bootstrap statistics makes it possible to pinpoint assemblages that require
 further investigation.

 The use of resampling options (\code{jackknife} and \code{bootstrap}) can
 lead to much longer execution times and larger output objects.
 To monitor the execution of these re-sampling procedures, a progress bar
 will automatically be displayed if the \code{\link[pbapply]{pbapply}}
 package is installed on your machine.
}

\examples{
\donttest{
# Coerce dataset to abundance (count) matrix
zuni <- as(zuni, "CountMatrix")

# Assume that some assemblages are reliably dated (this is NOT a real example).
# The names of the vector entries must match the names of the assemblages.
dates <- list(
  LZ0569 = 1097, LZ0279 = 1119, CS16 = 1328, LZ0066 = 1111,
  LZ0852 = 1216, LZ1209 = 1251, CS144 = 1262, LZ0563 = 1206,
  LZ0329 = 1076, LZ0005Q = 859, LZ0322 = 1109, LZ0067 = 863,
  LZ0578 = 1180, LZ0227 = 1104, LZ0610 = 1074
)

# Model the event and accumulation date for each assemblage.
(model <- dateEvent(zuni, dates, cutoff = 90))

# Plot results for the first five assemblages
# Plot event date distribution
plotDate(model, type = "event", select = 1:5) +
  ggplot2::theme_bw()
# Plot accumulation date distribution
plotDate(model, type = "acc", select = 1:5) +
  ggplot2::theme_bw()
# Plot both distributions
plotDate(model, select = "LZ1105") +
  ggplot2::theme_bw()

# Check model variability
checked <- dateEvent(zuni, dates, cutoff = 90,
                     jackknife = TRUE, bootstrap = TRUE, n = 1000)

# Extract results for the first 5 assemblages
## Modeled event dates
checked["rows", 1:5]
## Jackknife fabrics
checked["jackknife", 1:5]
## Bootstrap of assemblages
checked["bootstrap", 1:5]
}
}
\references{
Bellanger, L. & Husi, P. (2013). Mesurer et modéliser le temps inscrit dans
 la matière à partir d'une source matérielle : la céramique médiévale.
 In \emph{Mesure et Histoire Médiévale}. Histoire ancienne et médiévale.
 Paris: Publication de la Sorbonne, p. 119-134.

 Bellanger, L. & Husi, P. (2012). Statistical Tool for Dating and
 Interpreting Archaeological Contexts Using Pottery. \emph{Journal of
 Archaeological Science}, 39(4), 777-790.
 DOI: \href{https://doi.org/10.1016/j.jas.2011.06.031}{10.1016/j.jas.2011.06.031}.

 Bellanger, L., Tomassone, R. & Husi, P. (2008). A Statistical Approach for
 Dating Archaeological Contexts. \emph{Journal of Data Science}, 6, 135-154.

 Bellanger, L., Husi, P. & Tomassone, R. (2006). Une approche statistique
 pour la datation de contextes archéologiques. \emph{Revue de Statistique
 Appliquée}, 54(2), 65-81.

 Bellanger, L., Husi, P. & Tomassone, R. (2006). Statistical Aspects of
 Pottery Quantification for the Dating of Some Archaeological Contexts.
 \emph{Archaeometry}, 48(1), 169-183.
 DOI: \href{https://doi.org/10.1111/j.1475-4754.2006.00249.x}{10.1111/j.1475-4754.2006.00249.x}.

 Poblome, J. & Groenen, P. J. F. (2003). Constrained Correspondence Analysis
 for Seriation of Sagalassos Tablewares. In Doerr, M. & Apostolis, S. (eds.),
 \emph{The Digital Heritage of Archaeology}. Athens: Hellenic Ministry of
 Culture.

 South, S. A. (1977). \emph{Method and Theory in Historical Archaeology}.
 New York: Academic Press.
}
\seealso{
\link{refine}
}
\author{
N. Frerebeau
}
