% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reorganise.R
\name{reorganise}
\alias{reorganise}
\title{Reorganise a table}
\usage{
reorganise(input = NULL, schema = NULL)
}
\arguments{
\item{input}{[\code{data.frame(1)}]\cr table to reorganise.}

\item{schema}{[\code{symbol(1)}]\cr the schema description of \code{input}.}
}
\value{
A (tidy) table which is the result of reorganising \code{input} based
  on \code{schema}.
}
\description{
This function takes a disorganised messy table and rearranges columns and
rows into a tidy table based on a schema description.
}
\examples{
# a rather disorganised table with messy clusters and a distinct variable
(input <- tabs2shift$clusters_messy)

# put together schema description by ...
# ... identifying cluster positions
schema <- setCluster(id = "territories", left = c(1, 1, 4), top = c(1, 8, 8))

# ... specifying the cluster ID as id variable (obligatory)
schema <- schema \%>\%
    setIDVar(name = "territories", columns = c(1, 1, 4), rows = c(2, 9, 9))

# ... specifying the distinct variable (explicit position)
schema <- schema \%>\%
    setIDVar(name = "year", columns = 4, rows = c(3:6), distinct = TRUE)

# ... specifying a tidy variable (by giving the column values)
schema <- schema \%>\%
    setIDVar(name = "commodities", columns = c(1, 1, 4))

# ... identifying the (tidy) observed variables
schema <- schema \%>\%
    setObsVar(name = "harvested", columns = c(2, 2, 5)) \%>\%
    setObsVar(name = "production", columns = c(3, 3, 6))

# get the tidy output
reorganise(input, schema)

}
