% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_gen_TAR.R
\name{data.gen.tar}
\alias{data.gen.tar}
\title{Generate a two-regime threshold autoregressive (TAR) process.}
\usage{
data.gen.tar(
  nobs,
  ndim = 9,
  phi1 = c(0.6, -0.1),
  phi2 = c(-1.1, 0),
  theta = 0,
  d = 2,
  p = 2,
  noise = 0.1
)
}
\arguments{
\item{nobs}{the data length to be generated}

\item{ndim}{The number of potential predictors (default is 9)}

\item{phi1}{the coefficient vector of the lower-regime model}

\item{phi2}{the coefficient vector of the upper-regime model}

\item{theta}{threshold}

\item{d}{delay}

\item{p}{maximum autoregressive order}

\item{noise}{the white noise in the data}
}
\value{
A list of 2 elements: a vector of response (x), and a matrix of potential predictors (dp) with each column containing one potential predictor.
}
\description{
Generate a two-regime threshold autoregressive (TAR) process.
}
\details{
The two-regime Threshold Autoregressive  (TAR) model is given by the following formula:
\deqn{Y_t = \phi_{1,0}+\phi_{1,1} Y_{t-1} +\ldots+ \phi_{1,p} Y_{t-p}+\sigma_1 e_t, \mbox{  if } Y_{t-d}\le r}
\deqn{Y_t = \phi_{2,0}+\phi_{2,1} Y_{t-1} +\ldots+ \phi_{2,p} Y_{t-p}+\sigma_2 e_t, \mbox{  if } Y_{t-d} > r.}
where r is the threshold and d the delay.
}
\examples{
# TAR2 model from paper with total 9 dimensions
data.tar<-data.gen.tar(500)
plot.ts(cbind(data.tar$x,data.tar$dp))
}
\references{
Cryer, J. D. and K.-S. Chan (2008). Time Series Analysis With Applications in R Second Edition Springer Science+ Business Media, LLC.
}
