% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/total_within_cluster_variance.R
\name{total_within_cluster_variance}
\alias{total_within_cluster_variance}
\title{Calculate Total Within Cluster Variance of 3D points}
\usage{
total_within_cluster_variance(point_matrix, cluster_vector)
}
\arguments{
\item{point_matrix}{An n-by-3 numerical matrix where each
row corresponds to a single point in 3D space.}

\item{cluster_vector}{A numerical vector of cluster assignments, of
length n (ie one assignment per point).}
}
\value{
A one-element numeric vector holding calculated variance
}
\description{
Calculates \emph{Total Within Cluster Variance(TWCV)} of
3D points. This function is normally only used
indirectly through `validate_get_twcv`.
}
\section{TWCV}{

TWCV is a synr-specific term for a measure that aims to describe spread
of points in 3D space while taking into account that points belong
to distinct clusters.
TWCV is calculated in a multi-step process:
\enumerate{
 \item Each cluster's centroid is calculated.
 \item All points' squared distances to their corresponding centroids are
calculated.
 \item The point-to-centroid squared distances are summed up.
 \item The sum of squared distances is divided by the total number
of points, minus the number of clusters (to account for decreased
degrees of freedom).
}
}

\seealso{
\code{\link{centroid_3d_sq_dist}}
}
