% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_env.R
\name{plot_env}
\alias{plot_env}
\title{Environmental data plot based on CWT}
\usage{
plot_env(longitude, latitude, cluster_data, grid_data, cwt_number = 1,
  option = 1, na.rm = T, zmin, zmax, divide_units = 1,
  legend.lab = "", ...)
}
\arguments{
\item{longitude}{Numeric. vector containing longitudes.}

\item{latitude}{Numeric. vector containing latitudes.}

\item{cluster_data}{Integer containing the results of the synoptic classification.}

\item{grid_data}{Data frame containing the environmental data (i.e. precipitation, temperature, PM10, etc.)}

\item{cwt_number}{Integer. Number of CWT to plot.}

\item{option}{Integer (1 or 2), to manage latitude and longitude data when plot. Try 2 if 1 is wrong and viceversa. Default is 1.}

\item{na.rm}{Logical. If TRUE, all the grid points are used to calculate the daily mean although NA exists. If FALSE, only grid points with the complete serie are used to compute the daily mean. Default is TRUE.}

\item{zmin}{Integer. Minimum value to represent. Useful if you display many plots. Optional.}

\item{zmax}{Integer. Maximum value to represent. Useful if you display many plots. Optional.}

\item{divide_units}{Integer to divide previous units. Default is 1.}

\item{legend.lab}{Character. name of the variable used.}

\item{...}{Other graphical parameters.}
}
\description{
Plot the daily mean spatial distribution of an environmental data based on the synoptic classification
}
\examples{
# Load data (precp_grid and mslp)
data(precp_grid)
data(mslp)
# Converting our data, but without modifying time period
smode_mslp <- tidy_cuttime_nc(mslp, only_convert = TRUE)
precp_data <- tidy_cuttime_nc(precp_grid, only_convert = TRUE)
# classification performance
smode_clas <- synoptclas(smode_mslp$smode_data, ncomp = 6)
# Plot precipitation data based on cwt 3
plot_env(longitude = precp_grid$lon, latitude = precp_grid$lat,
         cluster_data = smode_clas$clas, grid_data = precp_data$smode_data,
         cwt_number = 3, option = 2, divide_units = 10, legend.lab = "mm")

}
\seealso{
\code{\link{synoptclas}}
}
