% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/install_course.R
\name{install_from_swirl}
\alias{install_from_swirl}
\title{Install a course from the official course repository}
\usage{
install_from_swirl(course_name, dev = FALSE, mirror = "github")
}
\arguments{
\item{course_name}{The name of the course you wish to install.}

\item{dev}{Set to \code{TRUE} to install a course in development from the swirl_misc repository.}

\item{mirror}{Select swirl course repository mirror. Valid arguments are \code{"github"} and \code{"bitbucket"}.}
}
\description{
We are currently maintaining a central repository of contributed
swirl courses at \url{https://github.com/swirldev/swirl_courses}.
This function provides the easiest method of installing a course
form the repository.

We have another repository at
\url{https://github.com/swirldev/swirl_misc}, where we keep
experimental features and content. The \code{dev} argument allows
you to access this repository. Content in the swirl_misc repository
is not guaranteed to work.

The central repository of swirl courses is mirrored at
\url{https://bitbucket.org/swirldevmirror/swirl_courses}. If you cannot
access GitHub you can download swirl courses from bitbucket by using the
\code{mirror = "bitbucket"} option (see below).
}
\examples{
\dontrun{

install_from_swirl("R_Programming") # Directory name

### OR ###

install_from_swirl("R Programming") # Course name

# To install a course in development from the swirl_misc repository
install_from_swirl("Including Data", dev = TRUE)

# To install a course from the Bitbucket mirror
install_from_swirl("R Programming", mirror = "bitbucket")
}
}
\seealso{
Other InstallCourses: \code{\link{InstallCourses}};
  \code{\link{install_course_directory}};
  \code{\link{install_course_dropbox}};
  \code{\link{install_course_github}};
  \code{\link{install_course_google_drive}};
  \code{\link{install_course_url}};
  \code{\link{install_course_zip}};
  \code{\link{uninstall_all_courses}};
  \code{\link{uninstall_course}}; \code{\link{zip_course}}
}

