% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sw_glance.R
\name{sw_glance}
\alias{sw_glance}
\title{Construct a single row summary "glance" of a model, fit, or other
object}
\usage{
sw_glance(x, ...)
}
\arguments{
\item{x}{model or other R object to convert to single-row data frame}

\item{...}{other arguments passed to methods}
}
\value{
single-row tibble with model summary information.
}
\description{
Construct a single row summary "glance" of a model, fit, or other
object
}
\details{
\code{sw_glance()} is a wrapper for \code{broom::glance()}. The benefit of \code{sw_glance}
is that it has methods for various time-series model classes such as
\code{HoltWinters}, \code{ets}, \code{Arima}, etc.
\code{sw_glance} methods always return either a one-row tibble or \code{NULL}.
The single row includes summary statistics relevent to the model accuracy,
which can be used to assess model fit and quality.

For non-time series, \code{sw_glance()} defaults to \code{broom::glance()}.
The only difference is that the return is a tibble.
}
\seealso{
\code{\link[broom:glance]{broom::glance()}}
}
