% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svs.r
\name{dist_wrt_centers}
\alias{dist_wrt_centers}
\title{Compute Distances with respect to Cluster Centers}
\usage{
dist_wrt_centers(x, clusters, freq = NULL, members_only = TRUE)
}
\arguments{
\item{x}{A numeric matrix (containing coordinates).}

\item{clusters}{A clustering of the row levels of \code{x}: either a list or the output of \code{kmeans}.}

\item{freq}{An optional vector of frequency counts for the row levels of \code{x}.}

\item{members_only}{Logical specifying whether the distances from the cluster centers should only be computed for
the cluster members.}
}
\value{
A list with a matrix of distances for every cluster.
}
\description{
A function for computing (euclidean) distances with respect to specified cluster centers.
}
\examples{
SndT_Fra <- read.table(system.file("extdata", "SndT_Fra.txt", package = "svs"),
   header = TRUE, sep = "\t", quote = "\"", encoding = "UTF-8",
   stringsAsFactors = FALSE)
sca.SndT_Fra <- fast_sca(SndT_Fra)
kcl.SndT_Fra <- kmeans(sca.SndT_Fra$pos1, centers = 7)
dist_wrt_centers(sca.SndT_Fra$pos1, clusters = kcl.SndT_Fra, freq = freq_ca(SndT_Fra[, 1]))
}
\seealso{
\code{\link{centers_ca}}, \code{\link{freq_ca}}.
}
