% Generated by roxygen2 (4.0.2): do not edit by hand
\name{fast_dca}
\alias{fast_dca}
\title{Discriminant Correspondence Analysis}
\usage{
fast_dca(dat, clusters1 = NULL, clusters2 = NULL, members = FALSE)
}
\arguments{
\item{dat}{Input data: can be a table or a data frame (but the data frame must have only two columns).}

\item{clusters1}{A clustering of the first set of levels: either a list or the output of \code{kmeans}.}

\item{clusters2}{A clustering of the second set of levels: either a list or the output of \code{kmeans}.}

\item{members}{Logical indicating whether the (supplementary) coordinates for the individual levels should also be computed.}
}
\value{
A list with components:
\item{\code{val} }{The eigenvalues or principal inertias, indicating how much each latent axis explains.}
\item{\code{cen1} }{The coordinates of the cluster centers for the first set of levels.}
\item{\code{cen2} }{The coordinates of the cluster centers for the second set of levels.}
\item{\code{mem1} }{If \code{members = TRUE}: The coordinates of the first set of individual levels.}
\item{\code{mem2} }{If \code{members = TRUE}: The coordinates of the second set of individual levels.}
}
\description{
A fast procedure for computing discriminant correspondence analysis.
}
\examples{
SndT_Fra <- read.table(system.file("extdata", "SndT_Fra.txt", package = "svs"),
   header = TRUE, sep = "\\t", quote = "\\"", encoding = "UTF-8")
sca.SndT_Fra <- fast_sca(SndT_Fra)
kcl.SndT_Fra <- kmeans(sca.SndT_Fra$pos1, centers = 7)
dca.SndT_Fra <- fast_dca(SndT_Fra, clusters1 = kcl.SndT_Fra)
dca.SndT_Fra
}
\references{
Abdi, H. (2007) Discriminant correspondence analysis. In: N. Salkind (ed.) \emph{Encyclopedia of measurement and statistics}. Thousand Oaks: SAGE.
}

