% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svgtools.R
\name{percentileBar}
\alias{percentileBar}
\title{Adjust (stacked) bar chart representing percentiles}
\usage{
percentileBar(
  svg,
  frame_name,
  group_name,
  scale_real,
  values,
  alignment = "horizontal"
)
}
\arguments{
\item{svg}{XML document with SVG content}

\item{frame_name}{Name (attribute 'id') of frame (XML element 'rect') for positioning bar segments.}

\item{group_name}{Name (attribute 'id') of group (XML element 'g') containing either bar segments or further groups, containing bar segments themselves.}

\item{scale_real}{Numeric vector (e.g. \code{c(0,100)}) of arbitrary length. Only minimum and maximum are used for scaling of values.}

\item{values}{Either a numeric vector, a numeric matrix or a dataframe with only numeric columns.\cr
If a vector is given, it corresponds to one bar (group of bar segments).\cr
If a matrix or dataframe is given, rows define the value set for several (stacked) bars grouped together.}

\item{alignment}{Character value. Accepts 'horizontal' (default) or 'vertical'. See details.}
}
\value{
XML document with SVG content
}
\description{
Adjusts the horizontal (XML attribute 'x') or vertical (XML attribute 'y') position as well as width/height of bar segments (XML elements of type 'rect') and optionally value labels (XML elements of type 'text'). First, values are ordered and transformed to differences between percentiles, providing a starting point and widths/heights for bar segments. Then, positions are calculated relative to a given frame (XML element of type 'rect') and the position of a value within the minimum and maximum of a given scale.\cr
No value labels are possible for this type of bar chart.\cr
For further description see \code{\link{stackedBar}}.
}
\details{
In contrast to \code{\link{stackedBar}} the value set(s) need(s) to have one more element than bar segments in each group.\cr
For everything else, see \code{\link{stackedBar}}.
}
\examples{
#read SVG file
fpath <- system.file("extdata", "fig9.svg", package="svgtools")
svg <- read_svg(file = fpath)

#adjust bars
set.seed(12345)
yy <- -2:2*15
percentiles <- data.frame(p5=rnorm(5,350,10)+yy, p25=rnorm(5,450,10)+yy, 
                          p50low=rnorm(5,510,10)+yy-1.5, p75=rnorm(5,560,10)+yy, 
                          p95=rnorm(5,640,10)+yy)
percentiles$p50upp <- percentiles$p50low+3
svg <- percentileBar(svg = svg, frame_name = "frame", group_name = "group",
                     scale_real = c(250,750), values = percentiles)
}
