% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{season_summary}
\alias{season_summary}
\title{Season summary}
\format{
This data frame contains the following columns:
\describe{
  \item{\code{season_name}}{Season name}
  \item{\code{season}}{Sesaon number}
  \item{\code{location}}{Location of the season}
  \item{\code{country}}{Country the season was held}
  \item{\code{tribe_setup}}{Initial setup of the tribe e.g. heroes vs Healers vs Hustlers}
  \item{\code{full_name}}{Full name of the winner}
  \item{\code{winner}}{Winner of the season}
  \item{\code{runner_ups}}{Runner ups for the season. Nested data from given there may be 2 runner ups and this preserves the grain of the data being a season}
  \item{\code{final_vote}}{Final vote allocation. See the \code{jury_votes} dataset for better aggregation of this data}
  \item{\code{timeslot}}{Timeslot of the show in the US}
  \item{\code{premiered}}{Date the first episode aired}
  \item{\code{ended}}{Date the season ended}
  \item{\code{filming_started}}{Date the filming of the season started}
  \item{\code{filming_ended}}{Date the filming ended (39 or 42 days after the start)}
  \item{\code{viewers_premier}}{Number of viewers (millions) who tuned in for the premier}
  \item{\code{viewers_finale}}{Number of viewers (millions) who tuned in for the finale}
  \item{\code{viewers_reunion}}{Number of viewers (millions) who tuned in for the reunion}
  \item{\code{viewers_mean}}{Average number of viewers (millions) who tuned in over the season}
  \item{\code{rank}}{Season rank}
}
}
\source{
\url{https://en.wikipedia.org/wiki/Survivor_(American_TV_series)}
}
\usage{
season_summary
}
\description{
A dataset containing a summary of all 40 seasons of survivor
}
\keyword{datasets}
