% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{vote_history}
\alias{vote_history}
\title{Vote history}
\format{
This data frame contains the following columns:
\describe{
  \item{\code{season_name}}{The season name}
  \item{\code{season}}{The season number}
  \item{\code{episode}}{Episode number}
  \item{\code{day}}{Day the tribal council took place}
  \item{\code{tribe_status}}{The status of the tribe e.g. original, swapped, merged, etc. See details for more}
  \item{\code{castaway}}{Name of the castaway}
  \item{\code{immunity}}{Type of immunity held by the castaway at the time of the vote e.g. individual,
  hidden (see details for hidden immunity data)}
  \item{\code{vote}}{The castaway for which the vote was cast}
  \item{\code{nullified}}{Was the vote nullified by a hidden immunity idol? Logical}
  \item{\code{voted_out}}{The castaway who was voted out}
  \item{\code{order}}{Boot order. Order in which castaway was voted out e.g. 5 is the 5th person voted of the island}
  \item{\code{vote_order}}{In the case of ties this indicates the order the votes took place}
  \item{\code{castaway_id}}{ID of the castaway (primary key). Consistent across seasons and name changes e.g. Amber Brkich / Amber Mariano. The first two letters reference the country of the version played e.g. US, AU. To recreated the old ID simply extract teh digits}
  \item{\code{vote_id}}{ID of the castaway voted for}
  \item{\code{voted_out_id}}{ID of the castaway voted_out}
}
}
\source{
\url{https://en.wikipedia.org/wiki/Survivor_(American_TV_series)}
}
\usage{
vote_history
}
\description{
A dataset containing details on the vote history for each season
}
\details{
This data frame contains a complete history of votes cast across all seasons of Survivor. While there are consistent
events across the seasons there are some unique events such as the 'mutiny' in Survivor: Cook Islands (season 13)
or the 'Outcasts' in Survivor: Pearl Islands (season 7). For maintaining a standard, whenever there has been a change
in tribe for the castaways it has been recorded as \code{swapped}. \code{swapped} is used as the
term since 'the tribe swap' is a typical recurring milestone in each season of Survivor. Subsequent changes are recorded with
a trailing digit e.g. \code{swapped2}. This includes absorbed tribes e.g. Stephanie was 'absorbed'
in Survivor: Palau (season 10) and when 3 tribes are
reduced to 2. These cases are still considered 'swapped' to indicate a change in tribe status.

Some events result in a castaway attending tribal but not voting. These are recorded as
\describe{
  \item{\code{Win}}{The castaway won the fire challenge}
  \item{\code{Lose}}{The castaway lost the fire challenge}
  \item{\code{None}}{The castaway did not cast a vote. This may be due to a vote steal or some other means}
  \item{\code{Immune}}{The castaway did not vote but were immune from the vote}
}

Where a castaway has \code{immunity == 'hidden'} this means that player is protected by a hidden immunity idol. It may not
necessarily mean they played the idol, the idol may have been played for them. While the nullified votes data is complete
the \code{immunity} data does not include those who had immunity but did not receive a vote. This is a TODO.

In the case where the 'steal a vote' advantage was played, there is a second row for the castaway that stole the vote.
The castaway who had their vote stolen are is recorded as \code{None}.

Many castaways have been medically evacuated, quit or left the game for some other reason. In these cases where no votes
were cast there is a skip in the \code{order} variable. Since no votes were cast there is nothing to record on this
data frame. The correct order in which castaways departed the island is recorded on \code{castaways}.

In the case of a tie, \code{voted_out} is recorded as \code{tie} to indicate no one was voted off the island in that
instance. The re-vote is recorded with \code{vote_order = 2} to indicate this is the second round of voting. In
the case of a second tie \code{voted_out} is recorded as \code{tie2}. The third step is either a draw of rocks,
fire challenge or countback (in the early days of survivor). In these cases \code{vote} is recorded as the colour of the
rock drawn, result of the fire challenge or 'countback'.
}
\examples{
# The number of times Tony voted for each castaway in Survivor: Winners at War
library(dplyr)
vote_history \%>\%
  filter(
    season == 40,
    castaway == "Tony"
  ) \%>\%
  count(vote)
}
\keyword{datasets}
