% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{surv_to_risk}
\alias{surv_to_risk}
\title{Safely convert a survival matrix prediction to a relative risk}
\usage{
surv_to_risk(x)
}
\arguments{
\item{x}{(\code{matrix()}) \cr TxN survival matrix prediction where T is number
of time-points and N is number of predicted observations. Colum names
correspond to predicted time-points and should therefore be coercable to
numeric and increasing. Entries are survival predictions and should
be (non-strictly) decreasing in each row.}
}
\description{
Many methods can be used to reduce a discrete survival
distribution prediction (i.e. matrix) to a relative risk / ranking
prediction. Here we define the predicted relative risk as the sum of
the predicted cumulative hazard function - which can be loosely interpreted
as the expected number of deaths for patients with similar characteristics.
}
\references{
Sonabend, R., Bender, A., & Vollmer, S. (2021).
Evaluation of survival distribution predictions with discrimination
measures. http://arxiv.org/abs/2112.04828.
}
