% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cumulative.table.R
\name{cumulative.table}
\alias{cumulative.table}
\title{Cumulative Percentage Table}
\usage{
cumulative.table(x)
}
\arguments{
\item{x}{object containing data for a single variable.}
}
\value{
A named numeric vector containing cumulative percentage frequencies, named by unique values of \code{x} and ordered numerically or alphabetically by name.
}
\description{
Returns as a named vector the cumulative percentage frequency distribution of a variable \code{x} at each unique value.
}
\details{
If \code{x} contains \code{NA} values (missing data), the cumulative percentage table will not reach 100. The table will end with the cumulative percentage of non-missing data within the object; the value remaining after subtracting this value from 100 represents the percentage of \code{NA} values within the object.
}
\examples{
# using variable without NA values
cumulative.table(NELS$famsize)

# using variable with NA values
cumulative.table(NELS$parmarl8)
}
\seealso{
\code{\link[sur]{percent.table}}, \code{\link[base]{cumsum}}, \code{\link[base]{table}}
}
