% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descr.R
\name{descr}
\alias{descr}
\title{Univariate Statistics for Numerical Data}
\usage{
descr(
  x,
  var = NULL,
  stats = st_options("descr.stats"),
  na.rm = TRUE,
  round.digits = st_options("round.digits"),
  transpose = st_options("descr.transpose"),
  order = "sort",
  style = st_options("style"),
  plain.ascii = st_options("plain.ascii"),
  justify = "r",
  headings = st_options("headings"),
  display.labels = st_options("display.labels"),
  split.tables = 100,
  weights = NULL,
  rescale.weights = FALSE,
  ...
)
}
\arguments{
\item{x}{A numerical vector or a data frame.}

\item{var}{Unquoted expression referring to a specific column in \code{x}.
Provides support for piped function calls (e.g.
\code{my_df |> descr(my_var)}.}

\item{stats}{Character. Which stats to produce. Either \dQuote{all} (default),
\dQuote{fivenum}, \dQuote{common} (see \emph{Details}), or a selection of :
\dQuote{mean}, \dQuote{sd}, \dQuote{min}, \dQuote{q1}, \dQuote{med},
\dQuote{q3}, \dQuote{max}, \dQuote{mad}, \dQuote{iqr}, \dQuote{cv},
\dQuote{skewness}, \dQuote{se.skewness}, \dQuote{kurtosis},
\dQuote{n.valid}, \dQuote{n}, and \dQuote{pct.valid}. Can be set globally
via \code{\link{st_options}}, option \dQuote{descr.stats}. See 
\emph{Details}.}

\item{na.rm}{Logical. Argument to be passed to statistical functions. 
Defaults to \code{TRUE}.}

\item{round.digits}{Numeric. Number of significant digits to display. 
Defaults to \code{2}. Can be set globally with \code{\link{st_options}}.}

\item{transpose}{Logical. Make variables appears as columns, and stats as
rows. Defaults to \code{FALSE}. Can be set globally with
\code{\link{st_options}}, option \dQuote{descr.transpose}.}

\item{order}{Character. When analyzing more than one variable, this parameter
determines how to order variables. Valid values are \dQuote{sort} (or
simply \dQuote{s}), \dQuote{preserve} (or \dQuote{p}), or a vector
containing all variable names in the desired order. Defaults to
\dQuote{sort}.}

\item{style}{Character. Style to be used by \code{\link[pander]{pander}}. One
of \dQuote{simple} (default), \dQuote{grid}, \dQuote{rmarkdown}, or
\dQuote{jira}. Can be set globally with \code{\link{st_options}}.}

\item{plain.ascii}{Logical. \code{\link[pander]{pander}} argument; when
\code{TRUE} (default), no markup characters will be used (useful when
printing to console). If \code{style = 'rmarkdown'} is specified, value
is set to \code{FALSE} automatically. Can be set globally using
\code{\link{st_options}}.}

\item{justify}{Character. Alignment of numbers in cells; \dQuote{l} for left,
\dQuote{c} for center, or \dQuote{r} for right (default). Has no effect on 
\emph{html} tables.}

\item{headings}{Logical. Set to \code{FALSE} to omit heading section. Can be
set globally via \code{\link{st_options}}. \code{TRUE} by default.}

\item{display.labels}{Logical. Show variable / data frame labels in heading
section. Defaults to \code{TRUE}. Can be set globally with
\code{\link{st_options}}.}

\item{split.tables}{Character. \code{\link[pander]{pander}} argument that
specifies how many characters wide a table can be. \code{100} by default.}

\item{weights}{Numeric. Vector of weights having same length as \emph{x}.
\code{NULL} (default) indicates that no weights are used.}

\item{rescale.weights}{Logical. When set to \code{TRUE}, a global constant is
apply to make the total count equal \code{nrow(x)}. \code{FALSE} by default.}

\item{\dots}{Additional arguments passed to \code{\link[pander]{pander}} or
\code{\link[base]{format}}.}
}
\value{
An object having classes \dQuote{\emph{matrix}} and
  \dQuote{\emph{summarytools}} containing the statistics, with extra
  attributes useful to other functions/methods.
}
\description{
Calculates mean, sd, min, Q1\*, median, Q3\*, max, MAD, IQR\*, CV, 
skewness\*, SE.skewness\*, and kurtosis\* on numerical vectors. (\*) Not 
available when using sampling weights.
}
\details{
Since version 1.1, the \emph{stats} argument can be set in a more flexible
  way; keywords (\emph{all}, \emph{common}, \emph{fivenum}) can be combined
  with single statistics, or their \dQuote{negation}. For instance, using 
  \code{stats = c("all", "-q1", "-q3")} would show
  \strong{all except q1 and q3}.
  
  For further customization, you could redefine any preset in the
  following manner: \code{.st_env$descr.stats$common <- c("mean", "sd", "n")}. 
  \emph{Use caution when modifying \code{.st_env}, and reload the package
  if errors ensue. Changes are temporary and will not persist across
  R sessions.}
}
\examples{
data("exams")

# All stats (default behavior) for all numerical variables
descr(exams)

# Show only "common" statistics, plus "n"
descr(exams, stats = c("common", "n"))

# Selection of statistics, transposing the results
descr(exams, stats = c("mean", "sd", "min", "max"), transpose = TRUE)

# Rmarkdown-ready
descr(exams, plain.ascii = FALSE, style = "rmarkdown")

# Grouped statistics
data("tobacco")
with(tobacco, stby(BMI, gender, descr, check.nas = FALSE))

# Grouped statistics in tidy table:
tb(with(tobacco, stby(BMI, age.gr, descr, stats = "common")))

\dontrun{
# Show in Viewer (or browser if not in RStudio)
view(descr(exams))

# Save to html file with title
print(descr(exams),
      file = "descr_exams.html", 
      report.title = "BMI by Age Group",
      footnote = "<b>Schoolyear:</b> 2018-2019<br/><b>Semester:</b> Fall")
}

}
\author{
Dominic Comtois, \email{dominic.comtois@gmail.com}
}
\keyword{univar}
